VERSION 5.00
Begin VB.UserControl SPA_Admin_PG_MKT 
   ClientHeight    =   9705
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15255
   ScaleHeight     =   9705
   ScaleWidth      =   15255
   Begin VB.Frame fra_detail 
      Height          =   8775
      Left            =   0
      TabIndex        =   10
      Tag             =   "fra_Detail"
      Top             =   840
      Width           =   15135
      Begin VB.Frame frm_JP_Experimental 
         Caption         =   "JP experimental"
         Height          =   1815
         Left            =   8640
         TabIndex        =   38
         Top             =   720
         Width           =   4335
         Begin VB.TextBox txt_JP_Exp_allItems 
            Height          =   1335
            Left            =   1200
            MultiLine       =   -1  'True
            TabIndex        =   40
            Top             =   360
            Width           =   3015
         End
         Begin VB.CommandButton cmdSelect_Admin 
            Caption         =   "Loop for all"
            Height          =   495
            Left            =   120
            TabIndex        =   39
            Top             =   360
            Width           =   975
         End
      End
      Begin VB.CheckBox chk_default 
         Alignment       =   1  'Right Justify
         Caption         =   "#Is default"
         Height          =   300
         Left            =   13410
         TabIndex        =   37
         Tag             =   "chk_default"
         Top             =   420
         Width           =   1575
      End
      Begin VB.TextBox txt_isActive 
         Height          =   345
         Left            =   3120
         TabIndex        =   35
         Tag             =   "VDate_EndDate"
         Text            =   "isActive"
         Top             =   600
         Visible         =   0   'False
         Width           =   1275
      End
      Begin VB.TextBox txt_VDate_Start 
         Height          =   345
         Left            =   120
         TabIndex        =   34
         Tag             =   "VDate_StartDate"
         Text            =   "NULL"
         Top             =   600
         Visible         =   0   'False
         Width           =   1275
      End
      Begin VB.TextBox txt_VDate_End 
         Height          =   345
         Left            =   1620
         TabIndex        =   33
         Tag             =   "VDate_EndDate"
         Text            =   "NULL"
         Top             =   600
         Visible         =   0   'False
         Width           =   1275
      End
      Begin VB.Frame fra_Product 
         Height          =   2550
         Left            =   120
         TabIndex        =   18
         Tag             =   "fra_Product"
         Top             =   840
         Width           =   14865
         Begin Project1.ToolbarControl tlb_Product 
            Height          =   2235
            Left            =   14040
            TabIndex        =   4
            Top             =   180
            Width           =   690
            _ExtentX        =   1217
            _ExtentY        =   3942
         End
         Begin Project1.ArmGrid grd_product 
            Height          =   2160
            Left            =   45
            TabIndex        =   3
            Tag             =   "grd_product"
            Top             =   255
            Width           =   13830
            _ExtentX        =   24395
            _ExtentY        =   3810
         End
      End
      Begin VB.Frame fra_authLevel 
         Height          =   5055
         Left            =   120
         TabIndex        =   12
         Tag             =   "fra_Product"
         Top             =   3600
         Width           =   14865
         Begin VB.Frame fra_manipulation 
            Caption         =   "#Manipulation"
            Height          =   1590
            Left            =   8160
            TabIndex        =   21
            Tag             =   "frm_maintenance"
            Top             =   3000
            Width           =   6570
            Begin VB.CheckBox chk_dropped 
               Caption         =   "#Dropped"
               Height          =   255
               Left            =   3870
               TabIndex        =   27
               Tag             =   "chk_dropped"
               Top             =   1170
               Width           =   1515
            End
            Begin VB.TextBox txt_dropDate 
               Alignment       =   2  'Center
               Enabled         =   0   'False
               Height          =   330
               Left            =   1740
               TabIndex        =   26
               Tag             =   "txt_dropDate"
               Text            =   "02/02/2001"
               Top             =   1132
               Width           =   1095
            End
            Begin VB.TextBox txt_updUser 
               Enabled         =   0   'False
               Height          =   330
               Left            =   3870
               TabIndex        =   25
               Tag             =   "txt_updUser"
               Text            =   "L. Cockayne"
               Top             =   742
               Width           =   2415
            End
            Begin VB.TextBox txt_lastUpd 
               Alignment       =   2  'Center
               Enabled         =   0   'False
               Height          =   330
               Left            =   1740
               TabIndex        =   24
               Tag             =   "txt_lastUpd"
               Text            =   "02/02/2001"
               Top             =   742
               Width           =   1095
            End
            Begin VB.TextBox txt_creator 
               Enabled         =   0   'False
               Height          =   330
               Left            =   3870
               TabIndex        =   23
               Tag             =   "txt_creator"
               Text            =   "L. Cockayne"
               Top             =   322
               Width           =   2415
            End
            Begin VB.TextBox txt_Date 
               Alignment       =   2  'Center
               Enabled         =   0   'False
               Height          =   330
               Left            =   1740
               TabIndex        =   22
               Tag             =   "txt_Date"
               Text            =   "02/02/2001"
               Top             =   322
               Width           =   1095
            End
            Begin VB.Label lbl_label 
               Caption         =   "#Drop date"
               Height          =   255
               Index           =   10
               Left            =   150
               TabIndex        =   32
               Tag             =   "lbl_dropDate"
               Top             =   1170
               Width           =   1530
            End
            Begin VB.Label lbl_label 
               Caption         =   "#By"
               Height          =   255
               Index           =   9
               Left            =   3150
               TabIndex        =   31
               Tag             =   "lbl_creator"
               Top             =   720
               Width           =   690
            End
            Begin VB.Label lbl_label 
               Caption         =   "#Last updade"
               Height          =   255
               Index           =   8
               Left            =   150
               TabIndex        =   30
               Tag             =   "lbl_dateUpd"
               Top             =   780
               Width           =   1530
            End
            Begin VB.Label lbl_label 
               Caption         =   "#By"
               Height          =   255
               Index           =   7
               Left            =   3150
               TabIndex        =   29
               Tag             =   "lbl_ByUser"
               Top             =   360
               Width           =   690
            End
            Begin VB.Label lbl_label 
               Caption         =   "#Creation date"
               Height          =   255
               Index           =   6
               Left            =   150
               TabIndex        =   28
               Tag             =   "lbl_date"
               Top             =   360
               Width           =   1530
            End
         End
         Begin VB.Frame fra_authLevelDetail 
            Caption         =   "#Authorization level detail "
            Height          =   1935
            Left            =   120
            TabIndex        =   13
            Tag             =   "fra_AuthLevelDetail"
            Top             =   2640
            Width           =   7095
            Begin VB.TextBox txt_level 
               Height          =   285
               Left            =   2400
               MaxLength       =   6
               TabIndex        =   9
               Text            =   "DiscountPercent"
               Top             =   1320
               Width           =   1575
            End
            Begin VB.TextBox txt_priority 
               BackColor       =   &H80000004&
               Height          =   285
               Left            =   2400
               TabIndex        =   8
               Text            =   "Priority"
               Top             =   840
               Width           =   1575
            End
            Begin Project1.ArmCombobox cbo_role 
               Height          =   345
               Left            =   2400
               TabIndex        =   7
               Top             =   360
               Width           =   4575
               _ExtentX        =   8070
               _ExtentY        =   609
            End
            Begin VB.Label lbl_label 
               Caption         =   "%"
               Height          =   255
               Index           =   5
               Left            =   4080
               TabIndex        =   17
               Tag             =   "lbl_Percent"
               Top             =   1320
               Width           =   495
            End
            Begin VB.Label lbl_label 
               Caption         =   "#Level"
               Height          =   255
               Index           =   4
               Left            =   240
               TabIndex        =   16
               Tag             =   "lbl_Level"
               Top             =   1320
               Width           =   2055
            End
            Begin VB.Label lbl_label 
               Caption         =   "#Priority"
               Height          =   255
               Index           =   3
               Left            =   240
               TabIndex        =   15
               Tag             =   "lbl_Priority"
               Top             =   840
               Width           =   2055
            End
            Begin VB.Label lbl_label 
               Caption         =   "#Role"
               Height          =   255
               Index           =   2
               Left            =   240
               TabIndex        =   14
               Tag             =   "lbl_Role"
               Top             =   360
               Width           =   2055
            End
         End
         Begin Project1.ToolbarControl tlb_authLevel 
            Height          =   2235
            Left            =   14040
            TabIndex        =   6
            Top             =   180
            Width           =   690
            _ExtentX        =   1217
            _ExtentY        =   3942
         End
         Begin Project1.ArmGrid grd_authLevel 
            Height          =   2160
            Left            =   45
            TabIndex        =   5
            Tag             =   "grd_authLevel"
            Top             =   255
            Width           =   13830
            _ExtentX        =   24395
            _ExtentY        =   3810
         End
      End
      Begin VB.TextBox txt_Key 
         Height          =   330
         Left            =   13320
         TabIndex        =   11
         Text            =   "SPGAM_Id"
         Top             =   0
         Visible         =   0   'False
         Width           =   1785
      End
      Begin Project1.ArmCombobox cbo_authMarket 
         Height          =   345
         Left            =   3000
         TabIndex        =   1
         Top             =   360
         Width           =   3570
         _ExtentX        =   6297
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_productGroup 
         Height          =   345
         Left            =   9345
         TabIndex        =   2
         Top             =   345
         Width           =   3570
         _ExtentX        =   6297
         _ExtentY        =   609
      End
      Begin Project1.A_calocx cal_changeRequested 
         Height          =   375
         Left            =   8640
         TabIndex        =   36
         Tag             =   "Date_From"
         Top             =   0
         Visible         =   0   'False
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   661
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Authorization market"
         Height          =   240
         Index           =   0
         Left            =   120
         TabIndex        =   20
         Tag             =   "lbl_AuthMarket"
         Top             =   412
         Width           =   2865
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Product group"
         Height          =   240
         Index           =   1
         Left            =   6615
         TabIndex        =   19
         Tag             =   "lbl_ProductGroup"
         Top             =   390
         Width           =   2625
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   15165
      _ExtentX        =   26749
      _ExtentY        =   1217
   End
End
Attribute VB_Name = "SPA_Admin_PG_MKT"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'what is new
'2.7.1 : Default product group - market link configuration for inserting new Base Items (JN)


' **************************************************************************************************
' ************************************* EXTERNAL DECLARATIONS **************************************
' **************************************************************************************************
Private Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
' **************************************************************************************************

' **************************************************************************************************
' **************************************** TOOL CONSTANTS ******************************************
' **************************************************************************************************
Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_APPNAME As String = "SPA_PG_MKT"                ' for error log
Private Const C_SCREENNAME As String = "SPA_Admin_PG_MKT" ' for loading screen constants
Private Const C_SCREENMODE_STACK_SIZE As Long = 5           ' size of stack for active screens
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "0"
Private Const C_TOOLBARFACE_ITEM_ADD As String = "1"
Private Const C_TOOLBARFACE_ITEM_UPD As String = "2"
Private Const C_TOOLBARFACE_ITEM_DEL As String = "3"
Private Const SIFYB_CM_ERROR_MESSAGE = 8000                 ' const for base of error messages ids
Private Const C_ID_KEY As String = "SPA_PG_MKT"             ' A_ID entry for new record
Private Const C_ID_KEY_BI As String = "SPA_PG_MKT_BI"       ' A_ID entry for new record
Private Const C_ID_KEY_LEVEL As String = "SPA_PG_MKT_LEVEL" ' A_ID entry for new record


' ****************************************** TOOL CONSTANTS ***************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    CompFncFailed = vbObjectError + 6           ' when component function fail
    QuietException = vbObjectError + 7          ' do not display error message
    WarMsgSelectRow = vbObjectError + 8
    SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 10 ' A SQL request does not return the expected rowcount : select an item return nothing...
End Enum

Private Enum ErrMsg
    ErrMsgNone = 0
    ErrMsgMandatoryAreEmpty = SIFYB_CM_ERROR_MESSAGE + 1
    ErrMsgDuplicateOrder = SIFYB_CM_ERROR_MESSAGE + 2
    ErrMsgDuplicateLevel = SIFYB_CM_ERROR_MESSAGE + 3
    ErrMsgMissingLevel = SIFYB_CM_ERROR_MESSAGE + 4
    ErrMsgNumericRequired = SIFYB_CM_ERROR_MESSAGE + 5
    ErrMsgItemIsDeleted = SIFYB_CM_ERROR_MESSAGE + 19
    ErrMsgPlanNotSelected = SIFYB_CM_ERROR_MESSAGE + 20
    ErrMsgItemAlreadyInGrid = SIFYB_CM_ERROR_MESSAGE + 21
    ErrMsgActionInProgress = SIFYB_CM_ERROR_MESSAGE + 22
    ErrMsgActionIsCompleted = SIFYB_CM_ERROR_MESSAGE + 23
    QueMsgActionIsCompleted = SIFYB_CM_ERROR_MESSAGE + 24
    ErrMsgVendorNotSelected = SIFYB_CM_ERROR_MESSAGE + 25
    QueMsgUpdateCompletedTask = SIFYB_CM_ERROR_MESSAGE + 26
    ErrMsgUpdateDeletedTask = SIFYB_CM_ERROR_MESSAGE + 27
    ErrMsg_M000 = SIFYB_CM_ERROR_MESSAGE + 0                ' undefined message
    ErrMsg_M150 = SIFYB_CM_ERROR_MESSAGE + 150              'This email address does not appear to be the correct format (User@domain)
    ErrMsg_M300 = SIFYB_CM_ERROR_MESSAGE + 300              'The Field $FIELD_NAME$ must be entered
    ErrMsg_M360 = SIFYB_CM_ERROR_MESSAGE + 360              'Do you really want to delete this record
    ErrMsg_M540 = SIFYB_CM_ERROR_MESSAGE + 540              'The same role cannot appear twice for this Authorisation Market/Product group combination
    ErrMsg_M550 = SIFYB_CM_ERROR_MESSAGE + 550              'The Authorisation level must be 100 for the highest priority role
    ErrMsg_M560 = SIFYB_CM_ERROR_MESSAGE + 560              'The Authorisation level you have chosen must be higer than the lower priority role and less than the higher priority role
    ErrMsg_M570 = SIFYB_CM_ERROR_MESSAGE + 570              'The Authorisation level you have selected aready exists for this Authorisation Market/Product group combination
    ErrMsg_M580 = SIFYB_CM_ERROR_MESSAGE + 580              'An authorisation level must exist for the highest priority role
    ErrMsg_M600 = SIFYB_CM_ERROR_MESSAGE + 600              'This authorisation market and product group already exists
    ErrMsg_M601 = SIFYB_CM_ERROR_MESSAGE + 601              'Default group for authorisation market already exists
    ErrMsg_M610 = SIFYB_CM_ERROR_MESSAGE + 610              'This configuration will be active from today or tomorrow and you cannot change it again today.
    ErrMsg_M706 = SIFYB_CM_ERROR_MESSAGE + 706              'This phone number does not appear to be the correct format (00xxx)
    ErrMsg_M723 = SIFYB_CM_ERROR_MESSAGE + 723              'Value must be between 0.01 and 100.00
End Enum

' *************************************** USER DEFINED ERRORS **************************************

' **************************************************************************************************
' *************************************** CONTROL MEMBERS ******************************************
' **************************************************************************************************
Dim ml_U_Code As Long                   ' if this is user loging app, needed to log errors into A_Log
Dim ms_LoginName As String
Dim ms_Language_Code As String
Dim mb_Initialized As Boolean           ' True if the component is already initialized
Dim mb_Initializing As Boolean          ' Flag of initializing
Dim mua_ActiveMode() As ArmScreenMode
Dim ms_Title As String                  ' title of user control - can be assigned as Caption to the parent form or title for printing
Dim ml_iConcurrency As Long             ' iconc of the record curently loaded
Dim ms_DecimalSeparator As String       ' decimal separator obtained from local settings
Dim ms_ThousandSeparator As String      'locale thousand separator

Dim moa_ListFieldsMandatory As Variant  ' all mandatory controls
Dim moa_ListFieldsNumeric As Variant    ' all numeric controls
Dim moa_ListFieldsToDisable() As Control ' common disabled control
Dim moa_DetailFieldsMandatory As Variant  ' all mandatory controls
Dim moa_DetailFieldsNumeric As Variant    ' all numeric controls
Dim ms_ErrMessage             As String

Private WithEvents mo_SPA_Admin_PG_MKT_BI   As SPA_Admin_PG_MKT_BI
Attribute mo_SPA_Admin_PG_MKT_BI.VB_VarHelpID = -1
Private mo_tokenManager       As ArmToken

Private Enum ArmScreenMode
    smRefreshOnly
    smMain
    smAdd
    smUpdate
    smDelete
    smView
    smAddItem
    smUpdateItem
    smDeleteItem
    smViewItem
    smSubProduct
End Enum

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

#If LIVE = 1 Then
    Dim mo_FSO As Object
#Else
    Dim mo_FSO As Scripting.FileSystemObject
#End If

' *************************************** CONTROL MEMBERS ******************************************
Public Event OnExit()
Public Event OnItemAdd(ByVal av_Key As Variant, ByVal as_SrzFields As String)
Public Event OnItemUpdate(ByVal av_Key As Variant, ByVal ab_removeOld As Boolean, ByVal as_SrzFields As String)
Public Event OnItemDelete(ByVal av_Key As Variant, ByVal as_SrzFields As String)
Public Event OnItemNext()
Public Event OnItemPrevious()
Public Event OnPrint(ByVal av_Key As Variant)


' **************************************************************************************************
' **************************************************************************************************
' **************************************************************************************************


' mb_Initialized is a read-only property, indicates the status of the component
Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub
Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property
Public Sub Zorder()
  Call UserControl.Extender.Zorder
End Sub
Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ml_U_Code = al_U_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".U_Code(Let)")
End Property

Public Property Let LoginName(ByVal as_LoginName As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_LoginName = as_LoginName
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LoginName(Let)")
End Property

Public Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_Language_Code) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_Language_Code = as_Language_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Language(Let)")
End Property

Public Property Set DB(ByRef ao_DB As ArmDb)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If ao_DB Is Nothing Then Call Err.Raise(ArmErr.InvalidArgument)
    
    Set mo_Db = ao_DB
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Db(Set)")
End Property

Public Property Get Title() As String
    Title = ms_Title
End Property

Public Sub PG_Deleted(ByVal al_SPG_Code As Long)
On Error GoTo ErrHandler
    If cbo_productGroup.Count > 0 Then
        ' combobox is loaded
        Call cbo_productGroup.DeleteItemKey(al_SPG_Code)
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".PG_Deleted")
End Sub

Public Sub PG_Updated(ByVal al_SPG_Code As Long, ByVal as_SPG_Desc As String)
On Error GoTo ErrHandler
    If cbo_productGroup.Count > 0 Then
        ' combobox is loaded
        Dim ll_i As Long
        
        For ll_i = 1 To cbo_productGroup.Count
            If cbo_productGroup.ComboItems(ll_i).Key = al_SPG_Code Then
                cbo_productGroup.ComboItems(ll_i).DisplayText = as_SPG_Desc
                Exit Sub
            End If
        Next
        ' item not found
        Call cbo_productGroup.AddItem(Array(al_SPG_Code, as_SPG_Desc))
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".PG_Updated")
End Sub

Public Sub MKT_Deleted(ByVal al_MKT_Code As Long)
On Error GoTo ErrHandler
    If cbo_authMarket.Count > 0 Then
        ' combobox is loaded
        Call cbo_authMarket.DeleteItemKey(al_MKT_Code)
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MKT_Deleted")
End Sub

Public Sub MKT_Updated(ByVal al_MKT_Code As Long, ByVal as_MKT_Desc As String)
On Error GoTo ErrHandler
    If cbo_authMarket.Count > 0 Then
        ' combobox is loaded
        Dim ll_i As Long
        
        For ll_i = 1 To cbo_authMarket.Count
            If cbo_authMarket.ComboItems(ll_i).Key = al_MKT_Code Then
                cbo_authMarket.ComboItems(ll_i).DisplayText = as_MKT_Desc
                Exit Sub
            End If
        Next
        ' item not found
        Call cbo_authMarket.AddItem(Array(al_MKT_Code, as_MKT_Desc))
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MKT_Updated")
End Sub

Public Sub Run(ByVal ae_ScrMode As SPA_Mode, ByVal av_Key As Variant)
On Error GoTo ErrHandler

    Debug.Assert (mb_Initialized = True)
    
    Call LockScreen(True)       'JN: i am not sure if this is necessary if called from other control which already locked the screen
    
    Select Case ae_ScrMode
        Case SPA_Mode.emView
            Call Item_ViewInit(av_Key)
        Case SPA_Mode.emAdd
            Call Item_AddInit
        Case SPA_Mode.emUpdate
            Call Item_UpdateInit(av_Key)
        Case SPA_Mode.emDelete
            Call Item_DeleteInit(av_Key)
            
    End Select
    
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".Run")
End Sub

Public Sub Load_A_COM()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If mo_Db Is Nothing Then Call Err.Raise(ArmErr.PropertyNotSet, "", "mo_Db")
    If Len(ms_Language_Code) < 1 Then Call Err.Raise(ArmErr.PropertyNotSet, "", "ms_Language_Code")
    
    ' get decimal separator for conversion from string to double
    ms_DecimalSeparator = Format(0, ".")
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If

    ' init token manager
    Set mo_tokenManager = New ArmToken
    Set mo_tokenManager.DB = mo_Db
    Call mo_tokenManager.Load_A_COM

    ' Set Db
    ' Call Load_A_Com
    ' Initialize toolbars
    Debug.Assert (Not mo_Db Is Nothing)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
            lo_Control.Locked = True
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.HideTips = True
            lo_Control.Load_A_COM
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    ReDim Preserve mua_ActiveMode(0)
    mua_ActiveMode(UBound(mua_ActiveMode)) = ArmScreenMode.smMain

    ' init controls
    
    ReDim moa_ListFieldsMandatory(0 To 1) As Variant
    moa_ListFieldsMandatory(0) = Array(cbo_authMarket, 0)
    moa_ListFieldsMandatory(1) = Array(cbo_productGroup, 1)
    
    InitMandatoryLabels (moa_ListFieldsMandatory)
    
    ' subdetail settings
    ReDim moa_DetailFieldsMandatory(0 To 1) As Variant
    moa_DetailFieldsMandatory(0) = Array(cbo_role, 2)
    moa_DetailFieldsMandatory(1) = Array(txt_level, 4)
    
    ReDim moa_DetailFieldsNumeric(0 To 0) As Variant
    moa_DetailFieldsNumeric(0) = Array(txt_level, 4)
    
    InitMandatoryLabels (moa_DetailFieldsMandatory)
    
    fra_Product.Font.Bold = True

    Call FillControlArray(moa_ListFieldsToDisable, Array(txt_Key, cal_changeRequested, txt_priority, txt_Date, txt_creator, txt_lastUpd, txt_updUser, txt_dropDate, chk_dropped))
    
    Call InitComponents
    
    Call LoadLabels(UserControl.Controls, C_SCREENNAME, ms_Language_Code)
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    Call Components_Settings
    
    ' set layout
    Call InitCtrlSize
    
    mb_Initialized = True

    ' display starting face
    Call UpdateUI(ArmScreenMode.smMain)
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_Com()")
End Sub

Private Sub FillControlArray(ByRef ao_ctrlArray() As Control, ByRef ao_array As Variant)
On Error GoTo ErrHandler
    Dim ll_i As Long
    If Not IsArray(ao_array) Then
        Exit Sub
    End If
    
    ReDim ao_ctrlArray(LBound(ao_array) To UBound(ao_array)) As Control
    
    For ll_i = LBound(ao_array) To UBound(ao_array)
        Set ao_ctrlArray(ll_i) = ao_array(ll_i)
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".FillControlArray()")
End Sub

Public Sub Unload_A_COM()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Not Initialized Then Call Err.Raise(ArmErr.CPTNotInitialized)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER", "SRM_TASKPRODUCT", "SRM_ACTION", "SRM_ATTACHMENT"
            Call lo_Control.Unload_A_COM
        End Select
    Next
    
    Call mo_tokenManager.Unload_A_COM

    Set mo_Db = Nothing
    Set mo_FSO = Nothing
    Set mo_tokenManager = Nothing

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Unload_A_Com()")
End Sub

Private Sub Components_Settings()
On Error GoTo ErrHandler

    Call Component_SetUp(txt_Key, "SPGAM_Id" & SEP & "Text")
    
    
    Call Component_SetUp(cbo_authMarket, "SPM_Code" & SEP & "SPM_SDesc")
    Call Component_SetUp(cbo_productGroup, "SPG_Code" & SEP & "SPG_SDesc")
    Call Component_SetUp(chk_default, "SPG_Default")
    Call Component_SetUp(txt_VDate_Start, "VDate_Start" & SEP & "Date")
    Call Component_SetUp(txt_VDate_End, "VDate_End" & SEP & "Date")
    Call Component_SetUp(txt_isActive, "isActive" & SEP & "Text")


    Call Component_SetUp(cbo_role, "SPR_Code" & SEP & "SPR_SDesc" & SEP & "Priority")
    Call Component_SetUp(txt_priority, "Priority" & SEP & "Num")
    Call Component_SetUp(txt_level, "DiscountPercent" & SEP & "Num" & SEP & PERCENT_FORMAT)
    
    ' system controls
    Call Component_SetUp(txt_Date, "Z_Creation" & SEP & "Date")
    Call Component_SetUp(txt_lastUpd, "Z_Last_Upd" & SEP & "Date")
    Call Component_SetUp(txt_dropDate, "Drop_Date" & SEP & "Date")
    Call Component_SetUp(txt_creator, "Z_Creator_Name" & SEP & "Text")
    Call Component_SetUp(txt_updUser, "Z_Last_Upd_User_Name" & SEP & "Text")
    Call Component_SetUp(chk_dropped, "Drop_flag")
    
    ' change required
    Call Component_SetUp(cal_changeRequested, "changeRequested")
    
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Components_Settings")
End Sub

Private Sub Component_SetUp(ByVal ao_cpt As Object, ByVal as_Tag As String)

On Error GoTo ErrHandler
    
    ao_cpt.Tag = as_Tag
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Component_SetUp")
End Sub


Private Sub InitPG_MKT_BI()
On Error GoTo ErrHandler
    If mo_SPA_Admin_PG_MKT_BI Is Nothing Then
        Set mo_SPA_Admin_PG_MKT_BI = UserControl.Controls.Add(C_ProgID & ".SPA_Admin_PG_MKT_BI", "mo_SPA_Admin_PG_MKT_BI", Me)
        mo_SPA_Admin_PG_MKT_BI.Visible = False
        Call mo_SPA_Admin_PG_MKT_BI.Move(0, 0, Extender.Width, Extender.Height)
        
        mo_SPA_Admin_PG_MKT_BI.Language_Code = ms_Language_Code
        mo_SPA_Admin_PG_MKT_BI.U_Code = ml_U_Code
        mo_SPA_Admin_PG_MKT_BI.LoginName = ms_LoginName
        Set mo_SPA_Admin_PG_MKT_BI.DB = mo_Db
        
        Call mo_SPA_Admin_PG_MKT_BI.Load_A_COM
        If Not mo_SPA_Admin_PG_MKT_BI.Initialized Then
            Call Err.Raise(ArmErr.CompFncFailed, "mo_SPA_Admin_PG_MKT_BI.Initialized", "SPA_Admin_PG_MKT_BI cannot was not initialised")
        End If
        mo_SPA_Admin_PG_MKT_BI.Zorder
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitPG_MKT_BI")
End Sub

Private Function UpdateUISubDetail(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly) As ArmScreenMode
On Error GoTo ErrHandler
    Static lu_lastScreen As ArmScreenMode
    
    If au_Mode = smRefreshOnly Then au_Mode = lu_lastScreen

    fra_detail.Visible = False
    tlb_Main.Visible = False
    If Not mo_SPA_Admin_PG_MKT_BI Is Nothing Then mo_SPA_Admin_PG_MKT_BI.Visible = False

    Select Case au_Mode
        Case smMain
            fra_detail.Visible = True
            tlb_Main.Visible = True
            If activeScreenMode = smAdd Then
                If grd_product.Rows > 0 Then
                    cbo_authMarket.Enabled = False
                    cbo_productGroup.Enabled = False
                Else
                    cbo_authMarket.Enabled = True
                    cbo_productGroup.Enabled = True
                End If
            End If

        Case smSubProduct
            If Not mo_SPA_Admin_PG_MKT_BI Is Nothing Then mo_SPA_Admin_PG_MKT_BI.Visible = True
        Case Else
            Debug.Assert (False)
    End Select
    
    UpdateUISubDetail = lu_lastScreen
    lu_lastScreen = au_Mode
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateUISubDetail")
End Function

Private Sub UpdateUI(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly)
On Error GoTo ErrHandler

    ' set active face
    If au_Mode <> smRefreshOnly Then
        Call pushScreenMode(au_Mode)
    End If

    tlb_Main.Redraw = False

    ' hide all frames
    fra_detail.Visible = False
    tlb_Main.Visible = False

    ' we have clean screen we can display proper controls
    Select Case activeScreenMode
        Case smMain
        Case smAdd
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_ADD)
            Call tlb_Product.DisplayFace("0")
            Call tlb_authLevel.DisplayFace("0")
        Case smUpdate
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_UPD)
            Call tlb_Product.DisplayFace("0")
            Call tlb_authLevel.DisplayFace("0")
        Case smView
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
            Call tlb_Product.DisplayFace("1")
            Call tlb_authLevel.DisplayFace("3")
        Case smDelete
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_DEL)
            Call tlb_Product.DisplayFace("1")
            Call tlb_authLevel.DisplayFace("3")
        Case smAddItem, smUpdateItem, smDeleteItem
            fra_detail.Visible = True
            fra_authLevelDetail.Visible = True
            tlb_Main.Visible = True
            Call tlb_authLevel.DisplayFace(IIf(activeScreenMode = smDeleteItem, "2", "1"))
        Case Else
            Debug.Assert (False)
    End Select
    
    ' apply rights on toolbar
    Call UpdateMainToolbar
    
    tlb_Main.Redraw = True

    ' to display face immidiatelly
    UserControl.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateUI()")
End Sub

' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************
Private Sub pushScreenMode(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    If UBound(mua_ActiveMode) = C_SCREENMODE_STACK_SIZE - 1 Then
        ' move array left
        Debug.Print ("Stack is too small. Increase C_SCREENMODE_STACK_SIZE constant please.")
        Dim ll_Index As Long
        For ll_Index = 1 To UBound(mua_ActiveMode)
            mua_ActiveMode(ll_Index - 1) = mua_ActiveMode(ll_Index)
        Next
    Else
        ' allocate one more item
        ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) + 1)
    End If
    mua_ActiveMode(UBound(mua_ActiveMode)) = au_Mode
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".pushScreenMode")
End Sub

Private Property Get activeScreenMode(Optional ByVal al_fromTop As Long = 0) As ArmScreenMode
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mua_ActiveMode))
    activeScreenMode = mua_ActiveMode(UBound(mua_ActiveMode) - al_fromTop)
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".activeScreenMode(Get)")
End Property

Private Sub popScreenMode()
On Error GoTo ErrHandler
    Debug.Assert (UBound(mua_ActiveMode) >= 1)
    ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) - 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenMode")
End Sub

Private Sub popScreenModeUntil(ByVal ae_goTo As ArmScreenMode)
On Error GoTo ErrHandler
    While activeScreenMode <> ae_goTo
        Call popScreenMode
    Wend
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenModeUntil")
End Sub


Private Sub InitComponents()
'Const CL_REQUEST_TB As String = "SELECT Info FROM Toolbars_Definitions WHERE ID=$id$"
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2422, 2822, $id$"

On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    Dim ll_cursor As Long
    Dim ll_i As Long
    
    'JP experimental frame
    frm_JP_Experimental.Visible = (ms_LoginName = "JPTROVO")
    
    ' main toolbar
    ll_cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_cursor, "id", TLB_SPA_PG_MKT_MTNC_ID) >= 0 Then
        Call tlb_Main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_cursor, "info"), Left(mo_Db.GetFields(ll_cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SPA_PG_MKT_MTNC_ID & ") not found in DB")
    End If
    
    If mo_Db.Find(ll_cursor, "id", TLB_SPA_PG_MKT_MTNC_PROD_ID) >= 0 Then
        Call tlb_Product.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_cursor, "info"), Left(mo_Db.GetFields(ll_cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SPA_PG_MKT_MTNC_PROD_ID & ") not found in DB")
    End If

    If mo_Db.Find(ll_cursor, "id", TLB_SPA_PG_MKT_MTNC_AUTH_ID) >= 0 Then
        Call tlb_authLevel.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_cursor, "info"), Left(mo_Db.GetFields(ll_cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SPA_PG_MKT_MTNC_AUTH_ID & ") not found in DB")
    End If

    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
    
    cbo_authMarket.FirstBlankItem = False
    cbo_authMarket.Request = REQ_AUTH_MARKET_CBO
    
    cbo_productGroup.FirstBlankItem = False
    cbo_productGroup.Request = REQ_PROD_GROUP_CBO
    
    cbo_role.FirstBlankItem = False
    cbo_role.Request = REQ_AUTH_ROLE_CBO
    
    grd_product.MultiSelect = True      'mw 24.06.2009
    grd_product.Title = "#Linked items"
    grd_product.AllowExcelExport = True
    grd_product.ExportTitles = True
    grd_product.ExportOnlyVisibleColumns = True
    Call grd_product.SetColumns(Array( _
          Join(Array("BI_SAP_Code", 1000, 1, "BI_SAP_Code", "", "String", "", "Left"), SEP) _
        , Join(Array("BI_Desc", 6000, 0, "BI_Desc", "#BI Desc", "String", "", "Left"), SEP) _
        , Join(Array("BI_SHORT_code", 2400, 0, "BI_SHORT_code", "#Short code", "String", "", "Left"), SEP) _
        , Join(Array("VDate_End", 0, 0, "VDate_End", "#Used until", "Date", "", "Left"), SEP) _
        , Join(Array("VDate_Free", 1200, 0, "VDate_Free", "#Free from", "Date", "", "Left"), SEP) _
        , Join(Array("change", 0, 0, "change", "", "String", "", "Left"), SEP) _
        ))
    
    grd_authLevel.MultiSelect = False
    grd_authLevel.Title = "#Auth levels"
    grd_authLevel.AllowExcelExport = True
    grd_authLevel.ExportTitles = True
    grd_authLevel.ExportOnlyVisibleColumns = True
    Call grd_authLevel.SetColumns(Array( _
          Join(Array("SPR_Code", 0, 1, "SPR_Code", "#SPR_Code"), SEP) _
        , Join(Array("SPR_SDesc", 3000, 0, "SPR_SDesc", "#Role desc"), SEP) _
        , Join(Array("DiscountPercent", 1300, 0, "DiscountPercent", "#discount(%)", "Float", PERCENT_FORMAT, "Left"), SEP) _
        , Join(Array("Priority", 1000, 0, "Priority", "#Priority", "String", "", "Left"), SEP) _
        , Join(Array("change", 0, 0, "change", "", "String", "", "Left"), SEP) _
        ))
        
    Exit Sub
ErrHandler:
    If ll_cursor <> 0 Then
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".InitComponents()")
End Sub

Private Sub InitMandatoryLabels(ByRef av_ListFieldsMandatory As Variant)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim lo_Label As Label

    For ll_Index = 0 To UBound(av_ListFieldsMandatory)
        If av_ListFieldsMandatory(ll_Index)(1) >= 0 Then
            Set lo_Label = lbl_Label(av_ListFieldsMandatory(ll_Index)(1))
            lo_Label.FontBold = True
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitMandatoryLabels")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = ReplacePlaceHolder(as_Request, "$language_code$", SQLStr(ms_Language_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Creator$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$U_Code$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Last_Upd_User$", SqlInt(ml_U_Code))
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplaceCommonPlaceholders")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function
Private Sub InitCtrlSize()
On Error GoTo ErrHandler
Const c_margin As Long = 60
    ' ??????????
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitCtrlSize()")
End Sub

Private Sub LoadDataToForm(ByVal ac_Cursor As Long, ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
   
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    Dim lValues As Variant
    Dim ls_TempTag As String
    
        lCount = aControls.Count - 1
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            ls_TempTag = lControl.Tag & SEP
                            lValues = Split(ls_TempTag, SEP)
                            If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                                Select Case lValues(1)
                                    Case "Text"
                                        lControl.Text = mo_Db.GetFields(ac_Cursor, lValues(0))
                                    Case "Num"
                                        If UBound(lValues) >= 3 Then
                                            ' formated number
                                            lControl.Text = Format(mo_Db.GetFields(ac_Cursor, lValues(0)), lValues(2))  'Replace(Format(mo_Db.GetFields(ac_Cursor, lValues(0)), lValues(2)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                        Else
                                            lControl.Text = mo_Db.GetFields(ac_Cursor, lValues(0))  'Replace(mo_Db.GetFields(ac_Cursor, lValues(0)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                        End If
                                    Case "Date"
                                        If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Then
                                            lControl.Text = ""
                                        Else
                                            lControl.Text = Format(mo_Db.GetFields(ac_Cursor, lValues(0)), "dd\/mm\/yyyy")
                                        End If
                                End Select
                            End If
                    
                    Case "ARMCOMBOBOX"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Or mo_Db.GetFields(ac_Cursor, lValues(0)) = "" Then
                                Set lControl.SelectedItem = Nothing
                            Else
                                If lControl.SearchItem(mo_Db.GetFields(ac_Cursor, lValues(0)), 0, 0, True) = False Then
                                    If lControl.AddItem(Array(mo_Db.GetFields(ac_Cursor, lValues(0)), mo_Db.GetFields(ac_Cursor, lValues(1))), True) Is Nothing Then
                                        Err.Raise 2222, "", ""
                                    End If
                                End If
                            End If
                        End If
                        
                    Case "OPTIONBUTTON"
                        lValues = Split(lControl.Tag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If UCase(lValues(2)) Like UCase(mo_Db.GetFields(ac_Cursor, lValues(0))) Then
                                lControl.Value = True
                            End If
                        End If
                        
                    Case "CHECKBOX"
                        If mo_Db.GetFieldIndex(ac_Cursor, lControl.Tag) >= 0 Then
                            If UCase(mo_Db.GetFields(ac_Cursor, lControl.Tag)) Like "X" Then
                                lControl.Value = vbChecked
                            Else
                                lControl.Value = vbUnchecked
                            End If
                        End If
                        
                    Case "A_CALOCX"
                        lControl.date_courte = Format(mo_Db.GetFields(ac_Cursor, lControl.Tag), "dd\/mm\/yyyy")
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "COMMANDBUTTON"
                        'Do Nothing
                    
                    Case "ARMGRID"
                        ' LOAD GRID
                    Case "ARMPICKER"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            lControl.ItemCode = mo_Db.GetFields(ac_Cursor, lValues(0))
                            lControl.ItemDescription = mo_Db.GetFields(ac_Cursor, lValues(1))
                            If lControl.ItemCode = "0" And lControl.ItemDescription = "" Then lControl.ItemCode = ""
                        End If
                    
                    Case Else
                        Debug.Print "LoadDataToForm  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    Exit Sub

ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadDataToForm")

End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control
    
    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(lLabels, "LOCAL_TEXT"), ctColumns)
                        End If
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                    End If
                Case "TABSTRIP"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(lLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    ' SPECIAL INITIALIZATION
    ' Title
    If mo_Db.Find(lLabels, "FIELD_NAME", "title", , 1) >= 0 Then
        ms_Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
    End If

    Call mo_Db.Close(lLabels)

    Exit Sub

ErrHandler:
    If lLabels > 0 Then
        Call mo_Db.Close(lLabels)
    End If
    Call ErrorHandler(Extender.Name & ".LoadLabels")
End Sub

Private Sub LoadDataToSubForm(ByRef as_detailData As Dictionary, ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
   
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ll_i As Long
    
        lCount = aControls.Count - 1
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            ls_TempTag = lControl.Tag & SEP
                            lValues = Split(ls_TempTag, SEP)
                            If as_detailData.Exists(lValues(0)) Then
                                Select Case lValues(1)
                                    Case "Text", "Tel", "Email"
                                        lControl.Text = as_detailData(lValues(0))
                                    Case "Num"
                                        If UBound(lValues) >= 3 Then
                                            ' formated number
                                            lControl.Text = Format(as_detailData(lValues(0)), lValues(2))  'Replace(Format(as_detailData(lValues(0)), lValues(2)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                        Else
                                            lControl.Text = as_detailData(lValues(0))   'Replace(as_detailData(lValues(0)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                        End If
                                    Case "Date"
                                        If as_detailData(lValues(0)) = "00:00:00" Or as_detailData(lValues(0)) = "" Then
                                            lControl.Text = ""
                                        Else
                                            lControl.Text = Format(as_detailData(lValues(0)), "dd\/mm\/yyyy")
                                        End If
                                End Select
                            End If
                    
                    Case "ARMCOMBOBOX"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If as_detailData.Exists(lValues(0)) Then
                            If as_detailData(lValues(0)) = 0 Or as_detailData(lValues(0)) = "" Then
                                Set lControl.SelectedItem = Nothing
                            Else
                                If lControl.SearchItem(as_detailData(lValues(0)), 0, 0, True) = False Then
                                    For ll_i = LBound(lValues) To UBound(lValues)
                                        lValues(ll_i) = as_detailData(lValues(ll_i))
                                    Next
                                    If lControl.AddItem(lValues, True) Is Nothing Then
                                        Err.Raise 2222, "", ""
                                    End If
                                End If
                            End If
                        End If
                        
                    Case "OPTIONBUTTON"
                        lValues = Split(lControl.Tag, SEP)
                        If as_detailData.Exists(lValues(0)) Then
                            If UCase(lValues(2)) Like UCase(as_detailData(lValues(0))) Then
                                lControl.Value = True
                            End If
                        End If
                        
                    Case "CHECKBOX"
                        If as_detailData.Exists(lControl.Tag) Then
                            If UCase(as_detailData(lControl.Tag)) Like "X" Then
                                lControl.Value = vbChecked
                            Else
                                lControl.Value = vbUnchecked
                            End If
                        End If
                        
                    Case "A_CALOCX"
                        lControl.date_courte = as_detailData(lControl.Tag)
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "COMMANDBUTTON"
                        'Do Nothing
                    
                    Case "ARMGRID"
                        ' LOAD GRID
                    Case "ARMPICKER"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If as_detailData.Exists(lValues(0)) Then
                            lControl.ItemCode = as_detailData(lValues(0))
                            lControl.ItemDescription = as_detailData(lValues(1))
                            If lControl.ItemCode = "0" And lControl.ItemDescription = "" Then lControl.ItemCode = ""
                        End If
                    
                    Case Else
                        Debug.Print "LoadDataToForm  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    Exit Sub

ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadDataToSubForm")

End Sub

Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control.Container Is SPA_Admin_PG_MKT Then
            If ao_parent.hwnd = lo_Control.Container.hwnd Then
                If TypeOf lo_Control Is Frame Then
                    Dim lo_aux_collection As New Collection
                    Dim ll_i As Long
                    Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                    For ll_i = 1 To lo_aux_collection.Count
                        lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                    Next
                Else
                    Call lo_retCollection.Add(lo_Control)
                End If
            End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetContainedControlsChain()")
End Function

' as_Name equals to Tag definition string

Private Function GetControl(ByVal ao_array As Object, ByVal as_Name As String) As Object
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_array
        If StrComp(lo_ctrl.Tag, as_Name, vbTextCompare) = 0 Then
            Set GetControl = lo_ctrl
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetControl()")
End Function

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call SetEnabledCtrl(lo_ctrl, ab_Value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_Value
            ao_ctrl.BackColor = IIf(ab_Value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "TABSTRIP", "A_CALOCX", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX", "CHECKBOX", "IMAGECOMBO"
            ao_ctrl.Enabled = ab_Value
        Case "ARMPICKER"
            ao_ctrl.Enabled = ab_Value
        Case "ARMGRID"
        End Select
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabledCtrl()")
End Sub


' loads values from cursor into form. if cursor=0 then reset whole detail
Private Sub Item_LoadValues(ByVal as_Key As String)
On Error GoTo ErrHandler
    Dim ls_req As String
    Dim ll_cursor As Long
    mb_Initializing = True
    If as_Key <> "" Then
        Debug.Assert (isNumeric(as_Key))
        
        ' load main record
        ls_req = Replace(ReplaceCommonPlaceholders(REQ_SELECT_SPA_PG_MKT), "$SPGAM_Id$", as_Key, , , vbTextCompare)
        ll_cursor = OpenSQLSafe(mo_Db, ls_req)
        
        txt_Key.Text = as_Key
        
        Call LoadDataToForm(ll_cursor, UserControl.Controls, Me)
        
        If Not grd_product.Load(Replace(ReplaceCommonPlaceholders(REQ_PG_MKT_BI_LINKED_LIST), "$SPGAM_Id$", as_Key, , , vbTextCompare), True, , , False) Then
            Call Err.Raise(ArmErr.CompFncFailed, "grd_product.Load", "Loading grid of products failed!")
        End If

        If Not grd_authLevel.Load(Replace(ReplaceCommonPlaceholders(REQ_AUTH_LEVEL_LIST), "$SPGAM_Id$", as_Key, , , vbTextCompare), True, , , False) Then
            Call Err.Raise(ArmErr.CompFncFailed, "grd_product.Load", "Loading grid of products failed!")
        End If

        ml_iConcurrency = mo_Db.GetFields(ll_cursor, "iConcurrency")
        
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
        
    Else
        ' load default values
        Dim ld_ServerDate As Date
        ld_ServerDate = GetServerDate()
        txt_Key.Text = "NEW"
        txt_Date.Text = Format(ld_ServerDate, "DD\/MM\/YYYY")
        txt_VDate_Start.Text = Format(ld_ServerDate, "DD\/MM\/YYYY")
        cal_changeRequested.date_courte = Format(ld_ServerDate, "DD\/MM\/YYYY")
        txt_isActive.Text = "X"
        txt_creator.Text = ms_LoginName
        grd_product.Requests = ""
        grd_authLevel.Requests = ""
    End If
    
    mb_Initializing = False

    Exit Sub
ErrHandler:
    If ll_cursor > 0 Then
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".Item_LoadValues")
End Sub

' free resources
Private Sub Item_Cleanup()
On Error GoTo ErrHandler
    mb_Initializing = True
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Cleanup")
End Sub

' clear all controls values
Private Sub Item_Clear()
On Error GoTo ErrHandler
    mb_Initializing = True
    Call ClearForm(UserControl.Controls, fra_detail)
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Clear")
End Sub

' initialize view mode
Private Sub Item_ViewInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smView)
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(CStr(as_detailKey(0)))
    
    Call UpdateUI(ArmScreenMode.smView)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ViewInit")
End Sub

' initialize delete mode
Private Sub Item_DeleteInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smDelete)
    Call Item_Clear
        
    Call Item_LoadValues(CStr(as_detailKey(0)))
    
    Call UpdateUI(ArmScreenMode.smDelete)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteInit")
End Sub


' initialize update mode
Private Sub Item_AddInit()
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smAdd)
    Call Item_Clear
        
    Call Item_LoadValues("")
    
    Call UpdateUI(ArmScreenMode.smAdd)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddInit")
End Sub

' initialize update mode
Private Sub Item_UpdateInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smUpdate)
    Call Item_Clear
        
    Call Item_LoadValues(CStr(as_detailKey(0)))
    
    Call UpdateUI(ArmScreenMode.smUpdate)
    
    
    If chk_dropped.Value = vbChecked Then
        ' deleted task cannot by edited
        Call MsgBox(MsgText(ErrMsgUpdateDeletedTask, ms_Language_Code, "#It is not possible to update already deleted task!"), vbInformation)
        ' move to view mode
        Call popScreenMode
        Call ResetScreen(ArmScreenMode.smView)
        Call UpdateUI(ArmScreenMode.smView)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateInit")
End Sub

Private Function Item_Validity_GetPossibleChange(ByVal al_oldKey As Long, ByVal ad_changeRequested As Date, ByRef ab_retRemovePossible As Boolean) As Date
On Error GoTo ErrHandler
    ' CHECK IF SPGAM_ID ise used today in some SPA_Item records for SPA_Header
    ab_retRemovePossible = False
    
    If SqlDate(txt_VDate_Start.Text) < SqlDate(ad_changeRequested) Then
        If EntryIsUsed(al_oldKey, ad_changeRequested) Then
            ad_changeRequested = ad_changeRequested + 1
        End If
    ElseIf SqlDate(txt_VDate_Start.Text) = SqlDate(ad_changeRequested) Then
        If EntryIsUsed(al_oldKey, ad_changeRequested) Then
            ad_changeRequested = ad_changeRequested + 1
        Else
            ' we can remove fom DB, because in this case rule was newer used
            ab_retRemovePossible = True
        End If
    Else    ' startDate>ad_changeRequested
        ' also in this case we can remove fom DB, because in this case rule was newer used
        ab_retRemovePossible = True
        ' and change possible can only be from start date of validity of the record
        If IsDate(txt_VDate_Start.Text) Then
            ad_changeRequested = CDate(txt_VDate_Start.Text)
        End If
    End If
        
    Item_Validity_GetPossibleChange = ad_changeRequested
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Validity_GetPossibleChange")
End Function





' deletes item
Private Function Item_Delete(ByVal av_oldKey As Variant) As Variant
On Error GoTo ErrHandler
    
    If SendMessage("Delete record ?", vbQuestion + vbYesNo) = vbYes Then
    
        If Not GetToken Then
            Call MsgBox(MsgText(mo_tokenManager.LastErrorCode, ms_Language_Code, mo_tokenManager.lastErrorMsg), vbInformation)
            Exit Function
        End If
        
        ms_ErrMessage = ""
        
        Dim ld_changePossible As Date
        Dim lb_removeOld As Boolean
        lb_removeOld = False
        
' debug: to test public function
'        ld_changePossible = SPA_Admin_PG_MKT_Delete(mo_Db, av_oldKey(0), txt_VDate_Start.Text, cal_changeRequested.date_dt(), ml_U_code)
        
        ld_changePossible = Item_Validity_GetPossibleChange(av_oldKey(0), cal_changeRequested.date_dt(), lb_removeOld)
        
        ' update item controls
        If ld_changePossible = cal_changeRequested.date_dt() Then
            txt_isActive.Text = ""
        End If
        txt_VDate_End.Text = Format(ld_changePossible - 1, "dd\/mm\/yyyy")

        Call Item_DeleteDB(av_oldKey(0), lb_removeOld, ld_changePossible)
        
        Call ReleaseToken

        If ms_ErrMessage <> "" Then
            Call MsgBox(ms_ErrMessage, vbInformation)
            Exit Function
        End If

        Dim ls_szStr As String
        ls_szStr = ""
        If Not lb_removeOld Then
            ls_szStr = Build_SrzString(UserControl.Controls, Me)
        End If
        RaiseEvent OnItemDelete(av_oldKey, ls_szStr)
        
        If lb_removeOld And activeScreenMode(1) = smView Then
            ' if we remove item from db, we cannot stay in detail
            Call popScreenMode
        End If

        Call Item_Exit
        
        Item_Delete = av_oldKey
    End If
    Exit Function
ErrHandler:
    Call UpdateError(True)
    Call ReleaseToken
    Call UpdateError(False)
    If Err.Number = SQLBadRowAffectedCount Then
         Err.Clear
         Call MsgBox(MsgText(ErrMsgDuplicateLevel, ms_Language_Code, "#Someone changed detail of this record and detail screen will be reloaded."), vbInformation)
         Call Item_Restore(av_oldKey)
         Exit Function
     End If
     Call ErrorHandler(Extender.Name & ".Item_Delete")
End Function

' workw with smView, smUpdate and smDelete mode
Private Sub Item_Restore(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(activeScreenMode)
    Call Item_Clear
    
    Call Item_LoadValues(CStr(as_detailKey(0)))
    Call UpdateUI
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Restore")
End Sub

' adds current edited item
Private Function Item_Add() As Variant
On Error GoTo ErrHandler
Dim lb_InTran As Boolean
    lb_InTran = False

    ' check values and throw message if neccessary
    If Not Item_Check(moa_ListFieldsMandatory, moa_ListFieldsNumeric) Then
        Exit Function
    End If
    
    ' test on M580
    If Not TestGridContaintRow(grd_authLevel, "Priority", "0", True) Then
        MsgBox MsgText(ErrMsg_M580, ms_Language_Code, "#An authorisation level must exist for the highest priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Function
    End If
    
    ' test on M590 id done on SubItem_add
    
    ' test on M600
    Dim ll_Err As ErrMsg
    ll_Err = Item_CheckPG_MKT()
    If ll_Err <> ErrMsg.ErrMsgNone Then
        MsgBox MsgText(ll_Err, ms_Language_Code, "#This authorisation market and product group already exists."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Function
    End If
    
    'check if there is default group existing for the market ( if new is default )
    If chk_default.Value = vbChecked Then
        ll_Err = Item_CheckDefaultPG_MKT()
        If ll_Err <> ErrMsg.ErrMsgNone Then
            MsgBox MsgText(ll_Err, ms_Language_Code, "#Default group for authorisation market already exists."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            Exit Function
        End If
    End If
    
    Dim ls_newCode As String
    Dim ls_newAltCode  As String
    ' get new code
    ls_newCode = mo_Db.SQLNextID(C_ID_KEY)
    txt_Key.Text = ls_newCode
    
    Dim ld_allItemsFreeFrom As Date
    ld_allItemsFreeFrom = GetGridColMaxValue2(grd_product, "VDate_End")
    If ld_allItemsFreeFrom <> 0 Then
        ls_newAltCode = mo_Db.SQLNextID(C_ID_KEY)
    Else
        ls_newAltCode = 0
    End If
    
    ms_ErrMessage = ""
    
    Call ExecuteSQLSafe(mo_Db, "BEGIN TRAN Item_Add")
    lb_InTran = True
    
    Call Item_AddDB(CLng(ls_newAltCode), cal_changeRequested.date_dt(), ld_allItemsFreeFrom)

    If ms_ErrMessage <> "" Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Add")
        lb_InTran = False
        Call MsgBox(ms_ErrMessage, vbInformation)
        Exit Function
    End If
    
    Call ExecuteSQLSafe(mo_Db, "COMMIT TRAN Item_Add")
    lb_InTran = False
    
    ' update fields accordig to what happens in Item_AddDB
    If ld_allItemsFreeFrom <> 0 Then
        ' we have 2 records
        ' real one is not active now and starts from ld_allItemsFreeFrom + 1
        txt_isActive.Text = ""
        txt_VDate_Start.Text = Format(ld_allItemsFreeFrom + 1, "dd\/mm\/yyyy")
    End If
    
    RaiseEvent OnItemAdd(CVar(Array(ls_newCode)), Build_SrzString(UserControl.Controls, Me) & "SPGAM_ID_ALT" & SEP1 & ls_newAltCode & SEP _
                                                                                            & "VDate_End_ALT" & SEP1 & Format(ld_allItemsFreeFrom, "DD\/MM\/YYYY") & SEP)

    Call Item_Exit
    
    Item_Add = CVar(Array(ls_newCode))
    Exit Function
ErrHandler:
    If lb_InTran Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Add")
        lb_InTran = False
    End If
    If Err.Number = SQLBadRowAffectedCount Then
        Call MsgBox("Error occured while inserting record, please contact IT")
        Exit Function
    End If

    Call ErrorHandler(Extender.Name & ".Item_Add")
End Function

' update current edited item
Private Function Item_Update(ByVal av_oldKey As Variant) As Variant
On Error GoTo ErrHandler
Dim lb_InTran As Boolean
    lb_InTran = False
    If Not Item_Check(moa_ListFieldsMandatory, moa_ListFieldsNumeric) Then
        Exit Function
    End If
    
    'check if there is default group existing for the market ( if new is default )
    If chk_default.Value = vbChecked Then
        Dim ll_Err As Long
        ll_Err = Item_CheckDefaultPG_MKT()
        If ll_Err <> ErrMsg.ErrMsgNone Then
            MsgBox MsgText(ll_Err, ms_Language_Code, "#Default group for authorisation market already exists."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            Exit Function
        End If
    End If

    If Not GetToken Then
        Call MsgBox(MsgText(mo_tokenManager.LastErrorCode, ms_Language_Code, mo_tokenManager.lastErrorMsg), vbInformation)
        Exit Function
    End If
    
    ms_ErrMessage = ""

    Dim ls_newCode As String
    Dim ls_newAltCode As String
    ' get new code
    ls_newCode = mo_Db.SQLNextID(C_ID_KEY)
    ' put NEW SPGAM_ID inside control on the form
    txt_Key.Text = ls_newCode
    
    Dim ld_allItemsFreeFrom As Date
    ld_allItemsFreeFrom = GetGridColMaxValue2(grd_product, "VDate_End")

    ' CHECK IF SPGAM_ID ise used today in some SPA_Item records for submited SPA_Header
    Dim ld_changePossible As Date
    Dim lb_removeOld As Boolean
    lb_removeOld = False
    
    ld_changePossible = Item_Validity_GetPossibleChange(av_oldKey(0), cal_changeRequested.date_dt(), lb_removeOld)
    
    ' update item controls
    If ld_changePossible = cal_changeRequested.date_dt() Then
        txt_isActive.Text = ""
    End If
    txt_VDate_End.Text = Format(ld_changePossible - 1, "dd\/mm\/yyyy")
    
    ' if all items are free after ld_changePossible, we will not create alterante rule
    If ld_changePossible > ld_allItemsFreeFrom Then
        ld_allItemsFreeFrom = 0
    End If

    If ld_allItemsFreeFrom <> 0 Then
        ls_newAltCode = mo_Db.SQLNextID(C_ID_KEY)
    Else
        ls_newAltCode = 0
    End If
    
    Call ExecuteSQLSafe(mo_Db, "BEGIN TRAN Item_Upd")
    lb_InTran = True
    
    Call Item_UpdateDB(av_oldKey(0), ls_newAltCode, lb_removeOld, ld_changePossible, ld_allItemsFreeFrom)
    
    If ms_ErrMessage <> "" Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Upd")
        lb_InTran = False
        Call ReleaseToken
    
        Call MsgBox(ms_ErrMessage, vbInformation)
        Exit Function
    End If
    
    Call ExecuteSQLSafe(mo_Db, "COMMIT TRAN Item_Upd")
    lb_InTran = False
    
    Call ReleaseToken
    
    ' send old SPGAM_Id in serialized string
    txt_Key.Text = av_oldKey(0)
    RaiseEvent OnItemUpdate(Array(ls_newCode), lb_removeOld, Build_SrzString(UserControl.Controls, Me) & _
                                                                "SPGAM_ID_ALT" & SEP1 & ls_newAltCode & SEP _
                                                                & "VDate_End_ALT" & SEP1 & Format(ld_allItemsFreeFrom, "DD\/MM\/YYYY") & SEP)
    txt_Key.Text = ls_newCode

    Call Item_Exit

    av_oldKey(0) = ls_newCode
    Item_Update = CVar(Array(av_oldKey(0)))

    Exit Function
ErrHandler:
    If lb_InTran Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Upd")
        lb_InTran = False
    End If
    Call UpdateError(True)
    Call ReleaseToken
    Call UpdateError(False)
    If Err.Number = SQLBadRowAffectedCount Then
        Err.Clear
        Call MsgBox(MsgText(ErrMsgDuplicateLevel, ms_Language_Code, "#Someone changed detail of this record and detail screen will be reloaded."), vbInformation)
        Call Item_Cleanup
        Call Item_Restore(av_oldKey)
        Exit Function
    End If
    Call ErrorHandler(Extender.Name & ".Item_Update")
End Function

Private Sub Item_AddDB(ByVal al_altCode As Long, ByVal ad_changePossible As Date, ByVal ad_allItemsFreeFrom As Date)
On Error GoTo ErrHandler
    Dim ls_req As String

    ' between ad_changePossible and ld_allItemsFreeFrom we must create records valid for free periods untill ld_allItemsFreeFrom
    ' to simplify we create only one record valid from ad_allItemsFreeFrom to ad_changePossible for free items
    
    '1. INSERT NEW PG/MKT COMBINATION WITH ALTERNATE CODE
    ' LOOP 1 ... IF THERE IS AT LEAST ONE ITEM FREE FROM ad_changePossible
    
    If ad_allItemsFreeFrom <> 0 Then
        Debug.Assert (al_altCode <> 0)
        ' ... ALL FREE RECORDS START FROM TODAY
        ls_req = ReplaceCommonPlaceholders(REQ_INSERT_SPA_PG_MKT)
        ls_req = ReplacePlaceHolder(ls_req, "$SPGAM_Id$", al_altCode)
        ls_req = ReplacePlaceHolder(ls_req, "$VDate_Start$", SqlDate(ad_changePossible))
        ls_req = ReplacePlaceHolder(ls_req, "$VDate_End$", SqlDate(ad_allItemsFreeFrom))
        ls_req = Item_ReplacePlaceholders(ls_req)

        Call ExecuteSQLSafe(mo_Db, ls_req, 1)
    
        'save grids
        Call SaveFreeItemsToDb(grd_product, REQ_PG_MKT_BI_INS, al_altCode)
        Call SaveGridToDb(grd_authLevel, REQ_PG_MKT_LEVEL_INS, al_altCode)
        ad_allItemsFreeFrom = ad_allItemsFreeFrom + 1
    Else
        ad_allItemsFreeFrom = ad_changePossible
    End If
    
    ' LOOP 2.... ALL RECORDS START FROM ad_allItemsFreeFrom to infinity
    ls_req = ReplaceCommonPlaceholders(REQ_INSERT_SPA_PG_MKT)
    ls_req = ReplacePlaceHolder(ls_req, "$VDate_Start$", SqlDate(ad_allItemsFreeFrom))
    ls_req = Item_ReplacePlaceholders(ls_req)

    Call ExecuteSQLSafe(mo_Db, ls_req, 1)

    'save grids
    Call SaveGridToDb(grd_product, REQ_PG_MKT_BI_INS, CLng(txt_Key.Text))
    Call SaveGridToDb(grd_authLevel, REQ_PG_MKT_LEVEL_INS, CLng(txt_Key.Text))

    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddDb")
End Sub

Private Function GetGridKeyColumnFieldName(ByRef ao_grid As ArmGrid) As String
On Error GoTo ErrHandler
    Dim ll_Col As Long
    
    GetGridKeyColumnFieldName = ""
    For ll_Col = 0 To ao_grid.Cols - 1
        If ao_grid.Columns(ll_Col).Key Then
            ' we have key
            GetGridKeyColumnFieldName = ao_grid.Columns(ll_Col).FieldName
            Exit For
        End If
    Next

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridKeyColumnFieldName")
End Function

' works only for one key column grids
Private Sub SaveGridToDb(ByRef ao_grid As ArmGrid, ByVal as_addReq As String, ByVal al_SPGAM_Id As Long)
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim ls_req  As String

    ' iterate grid and insert
    as_addReq = ReplaceCommonPlaceholders(as_addReq)
    
    For ll_Row = ao_grid.Rows - 1 To 0 Step -1
        If ao_grid.Data(ll_Row, "change") <> "D" Then
            ls_req = ReplacePlaceholderByGridRow(as_addReq, ao_grid, ll_Row)
            ls_req = ReplacePlaceHolder(ls_req, "$SPGAM_Id$", al_SPGAM_Id)
            Call ExecuteSQLSafe(mo_Db, ls_req, 1)
            
            ao_grid.Data(ll_Row, "change") = ""
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SaveGridToDb")
End Sub

Private Sub SaveFreeItemsToDb(ByRef ao_grid As ArmGrid, ByVal as_addReq As String, ByVal al_SPGAM_Id As Long)
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim ls_req  As String

    ' iterate grid and insert
    as_addReq = ReplaceCommonPlaceholders(as_addReq)
    
    For ll_Row = ao_grid.Rows - 1 To 0 Step -1
        If ao_grid.Data(ll_Row, "change") <> "D" Then
            If ao_grid.Data(ll_Row, "VDate_End") = 0 Then
                ' item is free => can be saved to db
                ls_req = ReplacePlaceholderByGridRow(as_addReq, ao_grid, ll_Row)
                ls_req = ReplacePlaceHolder(ls_req, "$SPGAM_Id$", al_SPGAM_Id)
                Call ExecuteSQLSafe(mo_Db, ls_req, 1)
            End If
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SaveGridToDb")
End Sub

' works only for one key column grids
Private Sub ClearGridToDb(ByRef ao_grid As ArmGrid, ByVal as_delReq As String)
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim ls_req  As String

    ' iterate grid and insert/update
    as_delReq = ReplaceCommonPlaceholders(as_delReq)
    
    For ll_Row = 0 To ao_grid.Rows - 1
        Select Case ao_grid.Data(ll_Row, "change")
        Case "A"
            ls_req = ReplacePlaceholderByGridRow(as_delReq, ao_grid, ll_Row)
            Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        Case "U", "D"
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearGridToDb")
End Sub

Private Sub Item_UpdateDB(ByVal as_oldCode As String, ByVal al_altCode As Long, ByVal ab_removeOld As Boolean, ByVal ad_changePossible As Date, ByVal ad_allItemsFreeFrom As Date)
On Error GoTo ErrHandler
    Dim ls_req As String
    
    '1. REMOVE/DISABLE CURRENT
    Call Item_DeleteDB(as_oldCode, ab_removeOld, ad_changePossible)
    
    ' for new record we must set VDate_End = ""
    Dim ls_oldVDate_End As String
    ls_oldVDate_End = txt_VDate_End.Text
    txt_VDate_End.Text = ""
    
    '2. INSERT NEW
    Call Item_AddDB(al_altCode, ad_changePossible, ad_allItemsFreeFrom)
    
    ' restore VDate_End
    txt_VDate_End.Text = ls_oldVDate_End

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateDb")
End Sub

Private Sub Item_DeleteDB(ByVal as_oldCode As String, ByVal lb_removeOld As Boolean, ByVal ld_changePossible As Date)
On Error GoTo ErrHandler
    Dim ls_req As String
    
    If lb_removeOld Then
        ' physically remove record from db
        ' 1. items
        ls_req = ReplacePlaceHolder(REQ_DELETE_DB3_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode)
        Call ExecuteSQLSafe(mo_Db, ls_req)
        
        ' 2. AuthLevel
        ls_req = ReplacePlaceHolder(REQ_DELETE_DB2_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode)
        Call ExecuteSQLSafe(mo_Db, ls_req)

        ' 3. Master record
        ls_req = ReplacePlaceHolder(REQ_DELETE_DB1_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode)
        ls_req = Item_ReplacePlaceholders(ls_req)
        Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        
    Else
        ' common placeholders
        ls_req = ReplacePlaceHolder(REQ_DELETE_SPA_PG_MKT, "$SPGAM_Id$", as_oldCode)
        ls_req = ReplaceCommonPlaceholders(ls_req)
        ls_req = Item_ReplacePlaceholders(ls_req)
        
        Call ExecuteSQLSafe(mo_Db, ls_req, 1)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteDb")
End Sub

' specia type od serialized string filed1_name sep1 data1 sep1 data2 sep field2_name ....
Private Function Build_SrzStringFromGrid(ByRef ao_grid As Control) As String
On Error GoTo ErrHandler
    Dim ls_ret As String
    Dim ls_Data As String
    Dim ll_Row As Long
    Build_SrzStringFromGrid = ""
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        ls_Data = ""
        For ll_Row = 0 To ao_grid.Rows - 1
            ls_Data = IIf(ll_Row = 0, "", ls_Data & SEP1) & lo_Column.GetData(ll_Row)
        Next
        ls_ret = IIf(ll_Col = 0, "", ls_ret & SEP) & lo_Column.FieldName & SEP1 & ls_Data
    Next
    
    Build_SrzStringFromGrid = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromGrid")
End Function

Private Function Build_SrzStringFromGridLine(ByRef ao_grid As Control, Optional ByVal al_Row As Long = -1) As String
On Error GoTo ErrHandler
    Dim ls_ret As String
    Build_SrzStringFromGridLine = ""
    If al_Row = -1 Then
        If ao_grid.SelectedCount > 0 Then
            al_Row = ao_grid.Row
        Else
            Call Err.Raise(ArmErr.InvalidArgument, "", "No row selected in grid.")
        End If
    End If
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        ls_ret = IIf(ll_Col = 0, "", ls_ret & SEP) & lo_Column.FieldName & SEP1 & lo_Column.GetData(al_Row)
    Next
    
    Build_SrzStringFromGridLine = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromGridLine")
End Function

Private Function Build_SrzStringFromControl(ByRef aControl As Control) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ls_Str As String

    Build_SrzStringFromControl = ""
                
    ls_TempTag = aControl.Tag & SEP
    lValues = Split(ls_TempTag, SEP)
    
    Select Case UCase(TypeName(aControl))
        Case "TEXTBOX"
                Select Case lValues(1)
                    Case "Text", "Date"
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.Text
                    Case "Num"
'                        ls_Str = Replace(aControl.Text, ms_ThousandSeparator, "")
'                        ls_Str = Replace(ls_Str, ms_DecimalSeparator, ".")
'                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & ls_Str
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.Text
               End Select
        
        Case "ARMCOMBOBOX"
            If Not aControl.SelectedItem Is Nothing Then
                ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.SelectedItem.Key & SEP
                ls_SrzString = ls_SrzString & lValues(1) & SEP1 & aControl.SelectedItem.GetData(1)
            Else
                ls_SrzString = ls_SrzString & lValues(0) & SEP1 & "NULL" & SEP
                ls_SrzString = ls_SrzString & lValues(1) & SEP1 & "" & SEP
            End If
        Case "OPTIONBUTTON"
            
        Case "CHECKBOX"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & IIf(aControl.Value = vbChecked, "X", "") & SEP
        
        Case "A_CALOCX"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.date_courte
            
            
        Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
            'Do Nothing
        
        Case "ARMGRID"
            ' do nothing
'            If aControl.SelectedCount > 0 Then
'                ls_SrzString = ls_SrzString & Build_SrzStringFromGridLine(aControl)
'            End If
        Case "ARMPICKER"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.ItemCode & SEP
            ls_SrzString = ls_SrzString & lValues(1) & SEP1 & aControl.ItemDescription
        
        Case Else
            Debug.Print "Build_SrzStringFromControl  -> " & UCase(TypeName(aControl))
    End Select

    Build_SrzStringFromControl = ls_SrzString
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromControl")
End Function


Private Function Build_SrzString(ByRef aControls As Variant, ByRef aContainer As Object) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lo_Control As CheckBox
    Dim lIdx As Long, lCount As Long
    
    Dim ls_Str As String
    Dim lControl As Control
   
    
        lCount = aControls.Count - 1
        ls_SrzString = ""
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                ls_Str = Build_SrzStringFromControl(lControl)
                If ls_Str <> "" Then
                    ls_SrzString = ls_SrzString & ls_Str & SEP
                End If
                
            End If
            Set lControl = Nothing
        Next

    ls_SrzString = Trim(ls_SrzString)
    Build_SrzString = ls_SrzString
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Build_SrzString")
End Function

Private Sub FillDataSrcArray(ByRef ao_dataSrc As Dictionary, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim ll_i As Long
    Dim lsa_DataFields() As String
    Dim lv_Values As Variant
    lsa_DataFields = Split(as_SrzFields, SEP)
    
    For ll_i = LBound(lsa_DataFields) To UBound(lsa_DataFields)
        lv_Values = Split(lsa_DataFields(ll_i), SEP1)
        If UBound(lv_Values) >= 1 Then
            Call ao_dataSrc.Add(lv_Values(0), lv_Values(1))
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("FillDataSrcArray")
End Sub

Private Function IsInArray(ByVal as_val As String, ByRef av_Array As Variant) As Boolean
On Error GoTo ErrHandler
    Dim ll_i As Long
    IsInArray = False
    For ll_i = LBound(av_Array) To UBound(av_Array)
        If StrComp(av_Array(ll_i), as_val, vbTextCompare) = 0 Then
            IsInArray = True
            Exit Function
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler("IsInArray")
End Function

' return number of realy deleted lines .. not the number of lines marked to be deleted
Private Function DeleteLineToGrid(ByVal ao_grid As ArmGrid, ByVal av_KeyFields As Variant, ByVal al_KeyVal As Variant) As Long
On Error GoTo ErrHandler
    DeleteLineToGrid = 0
    
    Dim ll_retVal As Long
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    Dim lba_bckKeys() As Boolean
    Dim lv_bckKey As Variant
    ReDim lba_bckKeys(0 To ao_grid.Cols - 1)
    
    ll_retVal = 0

    ' backup keys
    lv_bckKey = ao_grid.CurrentKey
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        lba_bckKeys(ll_Col) = lo_Column.Key
        lo_Column.Key = IsInArray(lo_Column.FieldName, av_KeyFields)
    Next

    ' delete all lines
    ao_grid.FirstLine
    Do While ao_grid.SearchKey(False, al_KeyVal)
        If ao_grid.DeleteLine Then
            ll_retVal = ll_retVal + 1
        End If
    Loop
    
    ' restore keys
    For ll_Col = 0 To ao_grid.Cols - 1
        ao_grid.Columns(ll_Col).Key = lba_bckKeys(ll_Col)
    Next
    Call ao_grid.SearchKey(True, lv_bckKey)
    
    DeleteLineToGrid = ll_retVal

    Exit Function
ErrHandler:
    Call ErrorHandler("DeleteLineToGrid")
End Function

Private Function IsKeyRow(ByVal ao_grid As ArmGrid, ByVal al_Row As Long, ByVal av_keyCols As Variant, ByRef ao_dataSrc As Dictionary) As Boolean
On Error GoTo ErrHandler
    IsKeyRow = False
    Dim ll_i As Long
    For ll_i = LBound(av_keyCols) To UBound(av_keyCols)
        If StrComp(ao_grid.Data(al_Row, av_keyCols(ll_i)), ao_dataSrc(av_keyCols(ll_i)), vbTextCompare) <> 0 Then
            Exit Function
        End If
    Next
    IsKeyRow = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsKeyRow")
End Function

Private Sub UpdateLineToGrid(ByVal ao_grid As ArmGrid, ByRef ao_dataSrc As Dictionary, ByVal av_keyCols As Variant)
On Error GoTo ErrHandler

    Debug.Assert (ao_grid.Cols > 0)
    Dim ll_Row As Long, ll_RowCount As Long, ll_Col As Long
    Dim lo_Column As ArmColumn
    
    ll_RowCount = ao_grid.Rows - 1
    For ll_Row = 0 To ll_RowCount
        If IsKeyRow(ao_grid, ll_Row, av_keyCols, ao_dataSrc) Then
            For ll_Col = 0 To ao_grid.Cols - 1
                Set lo_Column = ao_grid.Columns(ll_Col)
                If ao_dataSrc.Exists(lo_Column.FieldName) Then
                    If lo_Column.FieldType = DBTYPE_R4 Or lo_Column.FieldType = DBTYPE_R8 Then
'                        Call lo_Column.SetData(ll_Row, Replace(ao_dataSrc(lo_Column.FieldName), ".", ms_DecimalSeparator))
                        Call lo_Column.SetData(ll_Row, ao_dataSrc(lo_Column.FieldName))
                    Else
                        Call lo_Column.SetData(ll_Row, ao_dataSrc(lo_Column.FieldName))
                    End If
                End If
            Next
            ao_grid.LineColor(ll_Row) = COLOR_UPDLINE
        End If
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateLineToGrid")
End Sub

Private Sub AddLineToGrid(ByVal ao_grid As ArmGrid, ByRef ao_dataSrc As Dictionary, Optional ByVal ab_insertAtBeginning As Boolean = False)
On Error GoTo ErrHandler
    
    ' insert row at the end of grid
    Debug.Assert (ao_grid.Cols > 0)
    Dim lo_Column As ArmColumn
    Dim ll_Index As Long
    Dim lsa_newRow() As String
    ReDim lsa_newRow(0 To ao_grid.Cols - 1)
    
    Call ao_grid.DeselectRow
    
    For ll_Index = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Index)
        If ao_dataSrc.Exists(lo_Column.FieldName) Then
            If lo_Column.FieldType = DBTYPE_R4 Or lo_Column.FieldType = DBTYPE_R8 Then
'                lsa_newRow(ll_Index) = Replace(ao_dataSrc(lo_Column.FieldName), ".", ms_DecimalSeparator)
                lsa_newRow(ll_Index) = ao_dataSrc.Item(lo_Column.FieldName)
            Else
                lsa_newRow(ll_Index) = ao_dataSrc.Item(lo_Column.FieldName)
            End If
        Else
            lsa_newRow(ll_Index) = "TODO:"
        End If
    Next
    
    If ab_insertAtBeginning Then
        Call ao_grid.InsertLine(0, lsa_newRow)
        Call ao_grid.FirstLine
    Else
        Call ao_grid.AddLine(lsa_newRow)
    End If
    ao_grid.LineColor(ao_grid.Row) = COLOR_ADDLINE
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("AddLineToGrid")
End Sub
Private Function GetFieldValueFromSrz(ByVal as_SrzFields As String, ByVal as_Param As String) As String
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant
    Dim lv_Values
    Dim ll_Count As Long
    Dim ll_Nb As Long
       
    If right(as_SrzFields, 2) <> SEP Then as_SrzFields = as_SrzFields & SEP
       
    lv_SrzFields = Split(as_SrzFields, SEP)
    ll_Nb = UBound(lv_SrzFields) - 1

    For ll_Count = 0 To ll_Nb
        lv_Values = Split(lv_SrzFields(ll_Count), SEP1)
         If UCase(as_Param) = UCase(lv_Values(0)) Then
           GetFieldValueFromSrz = lv_Values(1)
           Exit For
         End If
    Next ll_Count
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetFieldValueFromSrz")
End Function

Private Sub SetCheckBoxDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByRef ao_CheckBox As VB.CheckBox, Optional ByVal as_checked As String = "X")
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, as_keyField)
    If Not IsEmpty(lv_val) Then
        ao_CheckBox.Value = IIf(lv_val = as_checked, vbChecked, vbUnchecked)
    Else
        ao_CheckBox.Value = vbUnchecked
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetCheckBoxDB")
End Sub


Private Sub SetComboBoxTextDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByVal as_DescField As String, ByRef ao_Combobox As ArmCombobox, Optional ByVal ab_clearIfNotExists As Boolean = True)
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, CVar(Array(as_keyField, as_DescField)))
    If Not IsEmpty(lv_val) Then
        Debug.Assert (UBound(lv_val) = 1)
        Call SetComboBoxText(ao_Combobox, CStr(lv_val(0)), CStr(lv_val(1)))
    Else
        If ab_clearIfNotExists Or mo_Db.GetFieldIndex(al_cursor, as_keyField) <> -1 Then
            Call ao_Combobox.Clear
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxTextDB")
End Sub

' Sets combobox selected item
' Params:
' ao_ComboBox (ArmCombobox)
' as_Key (String)
' as_Desc (String)
Private Sub SetComboBoxText(ByRef ao_Combobox As ArmCombobox, ByVal as_Key As String, ByVal as_Desc As String)
On Error GoTo ErrHandler
    If Not ao_Combobox.SearchItem(as_Key) Then
        ' key not found ... set value from parameter
        If as_Key = "" Or as_Key = "0" Then     ' zero or empty string is not valid key
            Set ao_Combobox.SelectedItem = Nothing
        Else
            Call ao_Combobox.AddItem(Array(as_Key, as_Desc), True)
            ' to make vb raise event
            Call ao_Combobox.SearchItem(as_Key)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxText")
End Sub

Private Function Item_ReplacePlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    ' general
    Dim ls_ret As String
    ls_ret = ReplaceRequestByFrameData(as_Request, fra_detail)
    
    ' default
    ls_ret = ReplacePlaceHolder(ls_ret, "$iConcurrency$", ml_iConcurrency)
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Created_Sent$", "NULL")
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Completed_Sent$", "NULL")
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Created$", "''")
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Completed$", "''")
    
    Item_ReplacePlaceholders = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ReplacePlaceholders")
End Function

' exits mode to main
Private Sub Item_Exit(Optional ByVal ab_reloadDetail As Boolean = False)
On Error GoTo ErrHandler
    
    ' pop last item in screen mode stack
'    Call popScreenModeUntil(smMain)
    Call popScreenMode
    
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    If activeScreenMode = smMain Then
        RaiseEvent OnExit
    ElseIf ab_reloadDetail Then Call Item_LoadValues(txt_Key.Text)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Exit")
End Sub

Private Function Item_Check(ByRef aoa_mandatory As Variant, ByRef aoa_numeric As Variant) As Boolean
On Error GoTo ErrHandler
        
'    Dim lv_MsgReplaceInfo(0, 1) As String
    Dim lo_Control As Object
    Dim ls_LabelCaption As String
    Dim ll_CtrlIndex As Long
    Dim lb_Found As Boolean
    Dim lo_mandatoryField As Variant
    
    If IsArray(moa_ListFieldsMandatory) Then
    
        For Each lo_mandatoryField In aoa_mandatory
            Set lo_Control = lo_mandatoryField(0)
                If lo_mandatoryField(1) >= 0 Then
                    ls_LabelCaption = lbl_Label(lo_mandatoryField(1)).Caption
                Else
                    ls_LabelCaption = ""
                End If
                Select Case UCase(TypeName(lo_Control))
                    Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                        ' Do nothing !

                    Case "TEXTBOX"
                        If lo_Control.Visible And (Not lo_Control.Locked) And (lo_Control.Text = "") Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            lo_Control.SetFocus
                            Exit Function
                        End If
                        
                    Case "ARMCHECKVIEW"
                         If lo_Control.Visible And (lo_Control.RoleList("EDIT").CheckedCount = 0) Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                          End If
                    Case "ARMGRID"
                        ' at least one non deleted row must be in grid
                        If lo_Control.Visible And GetGridNonDeletedRows(lo_Control) = 0 Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Exit Function
                        End If
                    Case "A_CALOCX"
                        If lo_Control.Visible And lo_Control.date_dt() = 0 Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                        End If
                    Case "ARMCHECKVIEW", "COMMANDBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP"
                    
                    Case "OPTIONBUTTON", "CHECKBOX"
                        'probably array of controls
                    Case "OBJECT"
                        lb_Found = False
                        For ll_CtrlIndex = 0 To lo_Control.Count - 1
                            If UCase(TypeName(lo_Control(ll_CtrlIndex))) = "CHECKBOX" Then
                                If lo_Control(ll_CtrlIndex).Value = vbChecked Then
                                    lb_Found = True
                                    Exit For
                                End If
                            ElseIf UCase(TypeName(lo_Control(ll_CtrlIndex))) = "OPTIONBUTTON" Then
                                If lo_Control(ll_CtrlIndex).Value Then
                                    lb_Found = True
                                    Exit For
                                End If
                            Else
                                ' unknown array ???
                                lb_Found = True
                                Exit For
                            End If
                        Next
                        If Not lb_Found Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Exit Function
                        End If
                    Case "ARMCOMBOBOX"
                        If lo_Control.Visible And lo_Control.Enabled And (lo_Control.SelectedItem Is Nothing) Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                        End If
                    Case "ARMPICKER"
                        If lo_Control.Visible And (CStr(lo_Control.ItemCode) = "") Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            lo_Control.SetFocus
                            Exit Function
                        End If
                    Case "LISTVIEW"
                         If lo_Control.Visible And (GetCheckedCount(lo_Control) = 0) Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                          End If
                    Case Else
                        Debug.Print "Item_CheckMandatory " & UCase(TypeName(lo_Control))
                End Select
        Next
    End If
    
    ' check all numeric fields on detail
    If Not IsArray(aoa_numeric) Then
        Item_Check = True
        Exit Function
    End If
    
    Dim lValues As Variant
    Dim ls_Str As String, ls_TempTag As String

    For Each lo_mandatoryField In aoa_numeric
        Set lo_Control = lo_mandatoryField(0)
            If lo_mandatoryField(1) >= 0 Then
                ls_LabelCaption = lbl_Label(lo_mandatoryField(1)).Caption
            Else
                ls_LabelCaption = ""
            End If
            
            ls_TempTag = lo_Control.Tag & SEP
            lValues = Split(ls_TempTag, SEP)
            Select Case UCase(TypeName(lo_Control))
                Case "TEXTBOX"
                     Select Case lValues(1)
                         Case "Text"     ' no chceck needed
                         Case "Date"
                             If lo_Control.Visible And Not IsDate(lo_Control.Text) Then
                                Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                                lo_Control.SetFocus
                                Exit Function
                             End If
                         Case "Num"
                            If UBound(lValues) >= 3 Then
                                ' formated number
                                lo_Control.Text = Format(Replace(lo_Control.Text, ".", ms_DecimalSeparator, , , vbTextCompare), lValues(2))
                            End If
                            
                            ls_Str = lo_Control.Text    'Replace(lo_Control.Text, ".", ms_DecimalSeparator, , , vbTextCompare)
                            If lo_Control.Visible Then
                                If Not isNumeric(ls_Str) Then
                                    Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                                    lo_Control.SetFocus
                                    Exit Function
                                End If
                                If CDbl(ls_Str) < C_MIN_VAL Or CDbl(ls_Str) > C_MAX_VAL Then
                                    ls_TempTag = ReplacePlaceHolder(MsgText(ErrMsg_M000, ms_Language_Code, "The field $FIELD_NAME$ must be between $C_MIN_VAL$ and $C_MAX_VAL$."), "$FIELD_NAME$", ls_LabelCaption)
                                    ls_TempTag = ReplacePlaceHolder(ls_TempTag, "$C_MIN_VAL$", C_MIN_VAL)
                                    ls_TempTag = ReplacePlaceHolder(ls_TempTag, "$C_MAX_VAL$", C_MAX_VAL)
                                    Call MsgBox(ls_TempTag, vbInformation)
                                    lo_Control.SetFocus
                                    Exit Function
                                End If
                             End If
                             lo_Control.Text = ls_Str
                        Case "Tel"
                            If lo_Control.Visible And lo_Control.Text <> "" Then
                                If Not IsTelNum(lo_Control.Text) Then
                                    ' M150
                                    Call MsgBox(MsgText(ErrMsg_M706, ms_Language_Code, "#M706 - This phone number does not appear to be the correct format (00xxx)."))
                                    lo_Control.SetFocus
                                    Exit Function
                                End If
                            End If
                        Case "Email"
                            If lo_Control.Visible And lo_Control.Text <> "" Then
                                If Not IsEMail(lo_Control.Text) Then
                                    ' M150
                                    Call MsgBox(MsgText(ErrMsg_M150, ms_Language_Code, "#M150 - This email address does not appear to be the correct format (User@domain)."))
                                    lo_Control.SetFocus
                                    Exit Function
                                End If
                            End If
                    End Select
                
                Case "ARMCOMBOBOX", "OPTIONBUTTON", "CHECKBOX", "A_CALOCX", "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "ARMGRID", "ARMPICKER"
                    ' do nothing
                
                Case Else
                    Debug.Print "Item_Check  -> " & UCase(TypeName(lo_Control))
            End Select
    Next

    Item_Check = True

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Check")
End Function

Private Function GetCheckedCount(ByRef ao_ListView As MSComctlLib.ListView) As Long
On Error GoTo ErrHandler

Dim lo_item As MSComctlLib.ListItem
Dim ll_Count As Long

    ll_Count = 0
    For Each lo_item In ao_ListView.ListItems
        If lo_item.Checked Then ll_Count = ll_Count + 1
    Next
    GetCheckedCount = ll_Count
    Exit Function
ErrHandler:
    Call ErrorHandler("GetCheckedCount")
End Function

Private Sub SetFocusToCtrl(ByRef ao_ctrl As Object)
On Error GoTo ErrHandler
    If ao_ctrl.Visible Then
        ao_ctrl.SetFocus
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".SetFocusToCtrl")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LockScreen")
End Sub

Private Sub ResetScreen(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    ' apply face
    Dim lo_ctrl As Object

    grd_authLevel.Enabled = True
    Select Case au_Mode
        Case smMain
            ' enable filtering a browsing
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
            Call SetEnabledCtrl(tlb_Main, True)
            
        Case smUpdate, smAdd
            ' we are in Update section
            Call SetEnabled(GetContainedControlsChain(fra_detail), True)
            Call SetEnabled(GetContainedControlsChain(fra_authLevelDetail), False)
            
            If au_Mode = smUpdate Then
                Call SetEnabledCtrl(cbo_authMarket, False)
                Call SetEnabledCtrl(cbo_productGroup, False)
            End If
            
            
            Dim lIdx As Long, lCount As Long
            
            If IsArray(moa_ListFieldsToDisable) Then
                lCount = UBound(moa_ListFieldsToDisable)
            
                For lIdx = 0 To lCount
                    Call SetEnabledCtrl(moa_ListFieldsToDisable(lIdx), False)
                Next
            End If
            
            Call SetEnabledCtrl(tlb_Main, True)
        Case smDelete, smView
            ' we are in PreView section
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
        Case smAddItem, smUpdateItem
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
            Call SetEnabled(GetContainedControlsChain(fra_authLevelDetail), True)
            
            If IsArray(moa_ListFieldsToDisable) Then
                lCount = UBound(moa_ListFieldsToDisable)
            
                For lIdx = 0 To lCount
                    Call SetEnabledCtrl(moa_ListFieldsToDisable(lIdx), False)
                Next
            End If
            
            If au_Mode = smUpdateItem Then
                Call SetEnabledCtrl(cbo_role, False)
            End If
            
            Call SetEnabledCtrl(tlb_Main, False)
            grd_authLevel.Enabled = False
        
        Case smDeleteItem
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
            
            If IsArray(moa_ListFieldsToDisable) Then
                lCount = UBound(moa_ListFieldsToDisable)
            
                For lIdx = 0 To lCount
                    Call SetEnabledCtrl(moa_ListFieldsToDisable(lIdx), False)
                Next
            End If
            Call SetEnabledCtrl(tlb_Main, False)
            grd_authLevel.Enabled = False
        Case Else
            Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ResetScreen()")
End Sub


Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
    HasContainer = False
    Dim lControl As Control
 
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend
 
NotFound:
    Set lControl = Nothing
    HasContainer = False
End Function
 
Private Function IsSub(ByVal av_Name As Object, ByRef aav_Names As Variant)
On Error GoTo ErrHandler
    IsSub = False
    
    Dim ll_Idx As Long
    For ll_Idx = LBound(aav_Names) To UBound(aav_Names)
    
        If av_Name Is aav_Names(ll_Idx) Then
            IsSub = True
            Exit Function
        End If
    Next ll_Idx
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsSub")
End Function

' Clear values for each control to not initiliazed
Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object, Optional ByRef aav_Except As Variant)
On Error GoTo ErrHandler
 
    'mb_internal = True
 
    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Dim lb_Process As Boolean
        lb_Process = True
        Set lControl = aControls.Item(lIdx)
        If Not IsMissing(aav_Except) Then
            If IsSub(lControl, aav_Except) Then
                lb_Process = False
            End If
        End If
        If HasContainer(lControl, aContainer) And lb_Process Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                Case "ARMCOMBOBOX"
'                    Set lControl.SelectedItem = Nothing
                    Call lControl.Clear
                Case "A_CALOCX"
                    lControl.reinit_cal
                Case "CHECKBOX"
                    lControl.Value = vbUnchecked
                Case "ARMCHECKVIEW"
                    lControl.UnCheckAll lControl.GetVisibleList
                    Dim ll_Idx As Long
                    For ll_Idx = 1 To lControl.RoleCount
                        lControl.RoleList(ll_Idx).ClearList
                    Next
                    lControl.SetVisibleList lControl.GetVisibleList
                    
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON"
 
                Case "ARMGRID"
                    lControl.ClearGrid
                Case "LISTBOX"
                    lControl.ListIndex = -1
                Case "OPTIONBUTTON"
                    lControl.Value = False
                Case "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "TOOLBARCONTROL", "LINE"
                
                Case "ARMPICKER"
                    Call lControl.Clear
                
                Case Else
                    Debug.Print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
 
        Set lControl = Nothing
    Next
 
   ' mb_internal = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearForm")
End Sub

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#End If
On Error GoTo ErrHandler
    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Call Err.Raise(CompFncFailed, "ao_Db.ExecuteSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            Call Err.Raise(SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(CompFncFailed, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler

    GetComboKey = ""
    If Not (ao_Combo.SelectedItem Is Nothing) Then
        GetComboKey = Trim(CStr(ao_Combo.SelectedItem.Key))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetComboKey")
End Function

Private Function SqlInt(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlInt = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlInt = CStr(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlInt")
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDate")
End Function

Private Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 8000) As String
On Error GoTo ErrHandler
    SQLStr = "'" & Replace(Left(as_str, IIf(Len(as_str) <= al_MaxLen, Len(as_str), al_MaxLen)), "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlStr")
End Function

' safe retieving selected item from combobox
Private Function SQLComboBoxValue(ByRef ao_Combobox As ArmCombobox, Optional ByVal as_DefaultValue As String = "NULL", Optional ByVal ab_KeyTitle As Boolean = True) As String
On Error GoTo ErrHandler
    If IsComboboxSelected(ao_Combobox) Then
        SQLComboBoxValue = "'" & IIf(ab_KeyTitle, ao_Combobox.SelectedItem.Key, ao_Combobox.SelectedItem.DisplayText) & "'"
    Else
        SQLComboBoxValue = as_DefaultValue
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLComboBoxValue")
End Function

Private Function SQLOptionButtonValue(ByRef ao_options As Object) As String
On Error GoTo ErrHandler
    SQLOptionButtonValue = ""
    Dim opt_obj As OptionButton
    For Each opt_obj In ao_options
        If opt_obj.Value Then
            SQLOptionButtonValue = opt_obj.Tag
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLOptionButtonValue")
End Function

Private Function IsComboboxSelected(ByRef as_combo As ArmCombobox) As Boolean
On Error GoTo ErrHandler
    IsComboboxSelected = False
    If Not as_combo.SelectedItem Is Nothing Then
        If Not IsEmpty(as_combo.SelectedItem.Key) Then
            IsComboboxSelected = True
        End If
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsComboboxSelected")
End Function

' ************************************************************************************

' ************************************************************************************
' **************************** REDIM FUNCTION ****************************************
' ************************************************************************************
Sub SafeRedimString(ByRef as_Array() As String, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim as_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(as_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedimString()")
End Sub

Sub SafeRedim(ByRef av_Array() As Variant, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim av_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(av_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedim()")
End Sub

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function GetDbError(ByVal lo_Db As Object) As String
#Else
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
#End If
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetDbError()")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , "Error message: " & as_Fct)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
    Dim ls_req As String
    Dim ll_cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_Code))
    ls_req = Replace(ls_req, "$APP$", SQLStr(C_APPNAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
    ls_req = Replace(ls_req, "$MSG$", SQLStr(as_logMsg, 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage()")
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Function SendMessage(ByVal as_msg As String, Optional Buttons As VbMsgBoxStyle = vbOKOnly) As VbMsgBoxResult
On Error GoTo ErrHandler
    Call LockScreen(True)
    SendMessage = MsgBox(as_msg, Buttons)
    Call LockScreen(False)
    Exit Function
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".SendMessage")
End Function

' function return original container
Private Function MoveControlToFront(ByRef ao_ctrl As Object) As Object
On Error GoTo ErrHandler
    Set MoveControlToFront = ao_ctrl.Container
    ao_ctrl.Top = ao_ctrl.Container.Top + ao_ctrl.Top
    ao_ctrl.Left = ao_ctrl.Container.Left + ao_ctrl.Left
    Set ao_ctrl.Container = ao_ctrl.Container.Container
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MoveControlToFront")
End Function

' recalculate position correctly only in case of one level hierachical change
Private Function MoveControlToFrame(ByRef ao_ctrl As Object, ByRef ao_Frame As VB.Frame) As Object
On Error GoTo ErrHandler
    Set MoveControlToFrame = ao_ctrl.Container
    Set ao_ctrl.Container = ao_Frame
    ao_ctrl.Top = ao_ctrl.Top - ao_Frame.Top
    ao_ctrl.Left = ao_ctrl.Left - ao_Frame.Left
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MoveControlToFrame")
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_cursor <> 0 Then Call ao_Armdb.Close(ll_cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".ChangeCharset")
End Sub

Private Function ReplacePlaceholderByGridRow(ByVal as_Request As String, ByRef ao_grid As ArmGrid, ByVal al_Row As Long) As String
On Error GoTo ErrHandler
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        Select Case lo_Column.FieldType
            Case DBTYPE_DATE
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SqlDate(lo_Column.GetData(al_Row)))
            Case DBTYPE_STR, DBTYPE_BSTR
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SQLStr(lo_Column.GetData(al_Row)))
            Case DBTYPE_I4
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SqlInt(lo_Column.GetData(al_Row)))
            Case DBTYPE_R4, DBTYPE_R8
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SqlDbl(lo_Column.GetData(al_Row)))
            Case Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", lo_Column.GetData(al_Row))
        End Select
    Next

    ReplacePlaceholderByGridRow = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ChangeCharset")
End Function

Private Function ReplacePlaceholderByControlValue(ByVal as_Request As String, ByRef ao_Control As Object) As String
On Error GoTo ErrHandler

Dim lsa_Columns() As String

    If Trim(ao_Control.Tag) = "" Then
        ReplacePlaceholderByControlValue = as_Request
        Exit Function
    End If
    
    Select Case UCase(TypeName(ao_Control))
        Case "ARMCOMBOBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If GetComboKey(ao_Control) = "" Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(GetComboKey(ao_Control)))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(ao_Control.Text))
            End If
        Case "ARMPICKER"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If (Trim(CStr(ao_Control.ItemCode)) = "") Or (CStr(ao_Control.ItemCode) = "0") Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(Trim(CStr(ao_Control.ItemCode))))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(Trim(ao_Control.ItemDescription)))
            End If
        Case "CHECKBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.Value = vbChecked Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr("X"))
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(""))
            End If
        Case "TEXTBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If UBound(lsa_Columns) > 0 Then
                
                Select Case lsa_Columns(1)
                    Case "Text"
                        as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
                    Case "Num"
                        If ao_Control.Text = "" Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
'                            Dim ls_number As String
'                            ls_number = Replace(Trim(ao_control.Text), ms_ThousandSeparator, "", , , vbTextCompare)
'                            ls_number = Replace(ls_number, ms_DecimalSeparator, ".", , , vbTextCompare)
'                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", ls_number)
                            
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDbl(ao_Control.Text))
                        End If
                    Case "Date"
                        If Not IsDate(ao_Control.Text) Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(CDate(ao_Control.Text)))
                        End If
                End Select
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
            End If
        Case "A_CALOCX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(ao_Control.date_dt))
        Case "TABSTRIP"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.SelectedItem Is Nothing Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.SelectedItem.Key))
            End If
    End Select
    ReplacePlaceholderByControlValue = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholderByControlValue")
End Function

Private Function ReplaceRequestByFrameData(ByVal as_Request As String, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
   
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Frame) Then
            as_Request = ReplacePlaceholderByControlValue(as_Request, lo_Control)
        End If
    Next
    ReplaceRequestByFrameData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByFrameData")
End Function


Private Sub FillDataSrcArrayFromGrid(ByRef ao_dataSrc As Dictionary, ByRef ao_grid As ArmGrid, ByVal al_Row As Long)
On Error GoTo ErrHandler
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    Call ao_dataSrc.RemoveAll
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        If Not ao_dataSrc.Exists(lo_Column.FieldName) Then Call ao_dataSrc.Add(lo_Column.FieldName, lo_Column.GetData(al_Row))
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("FillDataSrcArray")
End Sub


Private Sub cbo_role_ComboItemSelected()
On Error GoTo ErrHandler
    If mb_Initializing Then Exit Sub
    Call LockScreen(True)
    
    txt_priority.Text = cbo_role.SelectedItem.GetData(2)     ' Priority

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".cbo_role_ComboItemSelected")
End Sub

Private Sub cmdSelect_Admin_Click()
    Dim ll_i As Long
    Dim lsa_keys() As String
    
    lsa_keys = Split(txt_JP_Exp_allItems.Text, ",")
    
    Dim ll_Counter As Long
    ll_Counter = 0
    
    For ll_i = LBound(lsa_keys) To UBound(lsa_keys)
        If grd_product.SearchKey(True, Trim(lsa_keys(ll_i))) Then
            ll_Counter = ll_Counter + 1
            ' delete the line
            Call grd_product.DeleteSelectedLines
        End If
    Next
    
    MsgBox ("Found " & ll_Counter & " of " & (UBound(lsa_keys) - LBound(lsa_keys) + 1))
    
End Sub

Private Sub frm_JP_Experimental_DblClick()
    frm_JP_Experimental.Visible = False
End Sub

Private Sub grd_authLevel_SelChange()
On Error GoTo ErrHandler

    If mb_Initializing Then Exit Sub
    If grd_authLevel.SelectedCount = 0 Then Exit Sub
    
    Call LockScreen(True)
    
    Dim lo_detailData As Dictionary
    Set lo_detailData = New Dictionary
    lo_detailData.CompareMode = TextCompare
    
    ' fill array from selected gridrow
    Call FillDataSrcArrayFromGrid(lo_detailData, grd_authLevel, grd_authLevel.Row)
    
    Call SubItem_ViewInit(lo_detailData)
    
    Set lo_detailData = Nothing
    
    Call LockScreen(False)

    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".grd_authLevel_SelChange")
End Sub

Private Sub mo_SPA_Admin_PG_MKT_BI_OnExit()
On Error GoTo ErrHandler
    
    Call UpdateUISubDetail(smMain)

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_Admin_PG_MKT_BI_OnExit")
End Sub

Private Sub mo_SPA_Admin_PG_MKT_BI_OnItemAdd()
On Error GoTo ErrHandler
    
    ' only import grid
    Call mo_SPA_Admin_PG_MKT_BI.ExportLinkedGrid(grd_product)
    grd_product.Requests = ""
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_Admin_PG_MKT_BI_OnItemAdd")
End Sub

Private Sub mo_SPA_Admin_PG_MKT_BI_OnItemRestore()
On Error GoTo ErrHandler
    Call mo_SPA_Admin_PG_MKT_BI.ImportLinkedGrid(grd_product)
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_Admin_PG_MKT_BI_OnItemRestore")
End Sub

Private Sub tlb_authLevel_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_authLevel.Enabled = False

    Dim lo_detailData As Dictionary
    Set lo_detailData = New Dictionary
    lo_detailData.CompareMode = TextCompare

    Dim ll_msg As Long
    Select Case as_Role
        Case "A"
            ' Want to Add
            Call FillDataSrcArray(lo_detailData, Join(Array( _
                                                                Join(Array("SPI_Id", "NEW#" & (GetGridColMaxValue(grd_authLevel, "SPR_Code", "NEW#") + 1)), SEP1), _
                                                                Join(Array("change", "A"), SEP1)), SEP))
            Call SubItem_AddInit(lo_detailData)
        Case "B"
            
            ll_msg = SubItem_CanUpdate()
            If ll_msg = 0 Then
                ' fill array from selected gridrow
                Call FillDataSrcArrayFromGrid(lo_detailData, grd_authLevel, grd_authLevel.Row)
                Call SubItem_UpdateInit(lo_detailData)
            Else
                MsgBox MsgText(ll_msg, ms_Language_Code, "#Cannot Update."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case "C"
            ll_msg = SubItem_CanDelete()
            If ll_msg = 0 Then
                ' fill array from selected gridrow
                Call FillDataSrcArrayFromGrid(lo_detailData, grd_authLevel, grd_authLevel.Row)
                Call SubItem_DeleteInit(lo_detailData)
            Else
                MsgBox MsgText(ll_msg, ms_Language_Code, "#Cannot Delete."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case "T"
            Call SubItem_Exit
        Case "I" ' restore changes
            Select Case activeScreenMode
                Case smAddItem
                    Call FillDataSrcArray(lo_detailData, Join(Array( _
                                                                        Join(Array("SPI_Id", "NEW#" & (GetGridColMaxValue(grd_authLevel, "SPR_Code", "NEW#") + 1)), SEP1), _
                                                                        Join(Array("change", "A"), SEP1)), SEP))
                Case smUpdateItem
                    ' fill array from selected gridrow
                    Call FillDataSrcArrayFromGrid(lo_detailData, grd_authLevel, grd_authLevel.Row)
                Case Else
                    Err.Raise ArmErr.InvalidArgument, "tlb_item_action", "Unknown screenMode=" & activeScreenMode
            End Select
            Call SubItem_Restore(lo_detailData)
        Case "H" ' confirm changes
            Select Case activeScreenMode
                Case smAddItem
                    Call SubItem_Add
                Case smUpdateItem
                    Call SubItem_Update
                Case smDeleteItem
                    Call SubItem_Delete
                Case Else
                    Err.Raise ArmErr.InvalidArgument, "tlb_item_action", "Unknown screenMode=" & activeScreenMode
            End Select
        Case Else
            Err.Raise ArmErr.InvalidArgument, "tlb_item_action", "Unknown item toolbar role as_Role=" & as_Role
    End Select

    Set lo_detailData = Nothing
    
    tlb_authLevel.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    Set lo_detailData = Nothing
    tlb_authLevel.Enabled = True
    Call LockScreen(False)
    
    Call LogMessage("tlb_authLevel_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)

End Sub

Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    Dim ll_errCode As ErrMsg
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_Main.Enabled = False

    Select Case as_Role
        Case "A"
            Call Run(SPA_Mode.emAdd, Array(""))
        Case "C" 'delete button
            ll_errCode = Item_CanDelete
            If ll_errCode = ErrMsgNone Then
                Call Run(SPA_Mode.emDelete, Array(CLng(txt_Key.Text)))
            Else
                MsgBox MsgText(ll_errCode, ms_Language_Code, "#Cannot delete."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case "B" 'goto Update screen
            ll_errCode = Item_CanUpdate
            If ll_errCode = ErrMsgNone Then
                Call Run(SPA_Mode.emUpdate, Array(CLng(txt_Key.Text)))
            Else
                MsgBox MsgText(ll_errCode, ms_Language_Code, "#Cannot update."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case "I" 'Refresh update
            Call Item_Cleanup
            If isNumeric(txt_Key.Text) Then
                Call Item_Restore(Array(CLng(txt_Key.Text)))
            Else
                Call Item_Restore(Array(""))
            End If
            
        Case "H" 'validate mode add
            Select Case activeScreenMode
                Case ArmScreenMode.smAdd
                    Call Item_Add
                Case ArmScreenMode.smUpdate
                    Call Item_Update(Array(CLng(txt_Key.Text)))
                Case ArmScreenMode.smDelete
                    Call Item_Delete(Array(CLng(txt_Key.Text)))
                Case Else
                    Debug.Assert (False)
            End Select
        
        Case "Y" 'Goto next item
            Call popScreenMode
            RaiseEvent OnItemNext
            
            If activeScreenMode <> smView Then
                Call pushScreenMode(smView)
            End If

        Case "Z" 'Goto previous item
            Call popScreenMode
            RaiseEvent OnItemPrevious
        
            If activeScreenMode <> smView Then
                Call pushScreenMode(smView)
            End If
        
        Case "T"
            Call Item_Cleanup
            Call Item_Exit(activeScreenMode <> smDelete)
    End Select
    
    tlb_Main.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tlb_Main.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tlb_Main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select

    Exit Sub
End Sub

Private Function TestGridContaintRow(ByRef ao_grid As ArmGrid, ByVal as_colName As String, ByVal as_colVal As String, ByVal ab_incSelectedRow As Boolean, Optional ByVal as_colChangeName As String = "change", Optional ByVal as_deletedValue As String = "D") As Boolean
On Error GoTo ErrHandler
    Dim ll_Row As Long
    TestGridContaintRow = False
    For ll_Row = 0 To ao_grid.Rows - 1
        If StrComp(ao_grid.Data(ll_Row, as_colChangeName), as_deletedValue, vbTextCompare) <> 0 Then
            If ab_incSelectedRow Or (Not ab_incSelectedRow And ll_Row <> ao_grid.Row) Then
                If StrComp(ao_grid.Data(ll_Row, as_colName), as_colVal, vbTextCompare) = 0 Then
                    TestGridContaintRow = True
                    Exit Function
                End If
            End If
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".TestGridContaintRow")
End Function

Private Function TestGridNotContaintRow(ByRef ao_grid As ArmGrid, ByVal as_colName As String, ByVal as_colVal As String, ByVal ab_incSelectedRow As Boolean, Optional ByVal as_colChangeName As String = "change", Optional ByVal as_deletedValue As String = "D") As Boolean
On Error GoTo ErrHandler
    Dim ll_Row As Long
    TestGridNotContaintRow = True
    For ll_Row = 0 To ao_grid.Rows - 1
        If StrComp(ao_grid.Data(ll_Row, as_colChangeName), as_deletedValue, vbTextCompare) <> 0 Then
            If ab_incSelectedRow Or (Not ab_incSelectedRow And ll_Row <> ao_grid.Row) Then
                If StrComp(ao_grid.Data(ll_Row, as_colName), as_colVal, vbTextCompare) <> 0 Then
                    ' this means grid containt row which is not of value as_colVal
                    TestGridNotContaintRow = False
                    Exit Function
                End If
            End If
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".TestGridNotContaintRow")
End Function

Private Function GetGridNonDeletedRows(ByRef ao_grid As ArmGrid, Optional ByVal as_colName As String = "change", Optional ByVal as_deletedValue As String = "D") As Long
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim ll_retVal As Long
    ll_retVal = 0
    For ll_Row = 0 To ao_grid.Rows - 1
        If StrComp(ao_grid.Data(ll_Row, as_colName), as_deletedValue, vbTextCompare) <> 0 Then ll_retVal = ll_retVal + 1
    Next
    GetGridNonDeletedRows = ll_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridNonDeletedRows")
End Function
Private Function GetGridColMaxValue(ByRef ao_grid As ArmGrid, ByVal as_colName As String, ByVal as_like As String) As Long
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim ls_Data As String
    Dim ll_retVal As Long
    ll_retVal = 0
    For ll_Row = 0 To ao_grid.Rows - 1
        ls_Data = ao_grid.Data(ll_Row, as_colName)
        If Len(ls_Data) > Len(as_like) Then
            If StrComp(Left(ls_Data, Len(as_like)), as_like, vbTextCompare) = 0 Then
                ls_Data = right(ao_grid.Data(ll_Row, as_colName), Len(ao_grid.Data(ll_Row, as_colName)) - Len(as_like))
                If isNumeric(ls_Data) Then
                    If CLng(ls_Data) > ll_retVal Then ll_retVal = CLng(ls_Data)
                End If
            End If
        End If
    Next
    GetGridColMaxValue = ll_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridColMaxValue")
End Function

Private Function GetGridColMaxValue2(ByRef ao_grid As ArmGrid, ByVal as_colName As String, Optional ByVal as_colChangeName As String = "change", Optional ByVal as_deletedValue As String = "D") As Variant
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim lv_retVal As Variant
    lv_retVal = Empty
    For ll_Row = 0 To ao_grid.Rows - 1
        If StrComp(ao_grid.Data(ll_Row, as_colChangeName), as_deletedValue, vbTextCompare) <> 0 Then
            If (lv_retVal < ao_grid.Data(ll_Row, as_colName)) Then
                lv_retVal = ao_grid.Data(ll_Row, as_colName)
            End If
        End If
    Next
    GetGridColMaxValue2 = lv_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridColMaxValue2")
End Function

Private Sub tlb_product_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_Product.Enabled = False



    Select Case as_Role
        Case "A"
            ' Want to Add
'            Call UpdateUI(smAddItem)
            If Not cbo_authMarket.SelectedItem Is Nothing Then
                If Not cbo_productGroup.SelectedItem Is Nothing Then
                    Call InitPG_MKT_BI
                    ' load detail
                    
                    If Not mo_SPA_Admin_PG_MKT_BI Is Nothing Then
                        Call mo_SPA_Admin_PG_MKT_BI.Run(SPA_Mode.emAdd, Build_SrzString(UserControl.Controls, fra_detail))
                        Call mo_SPA_Admin_PG_MKT_BI.ImportLinkedGrid(grd_product)
                        Call UpdateUISubDetail(smSubProduct)
                    End If
                Else
                    Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", lbl_Label(1).Caption), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
                End If
            Else
                Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", lbl_Label(0).Caption), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
            End If
        Case "C"
            If grd_product.SelectedCount > 0 Then
                If grd_product.CurrentLine("change") <> "D" Then
                    If SendMessage(MsgText(ErrMsg_M360, ms_Language_Code, "#Do you really want to delete this record."), vbQuestion + vbYesNo) = vbYes Then
                        ' remove selected line from the grid
                        Call grd_product.DeleteSelectedLines
                        If activeScreenMode = smAdd Then
                            If grd_product.Rows = 0 Then
                                cbo_authMarket.Enabled = True
                                cbo_productGroup.Enabled = True
                            End If
                        End If

                    End If
                Else
                    MsgBox MsgText(ErrMsgItemIsDeleted, ms_Language_Code, "#Row is deleted."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If
            Else
                MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case Else
            Err.Raise ArmErr.InvalidArgument, "tlb_Product_action", "Unknown main toolbar role as_Role=" & as_Role
    End Select

    tlb_Product.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tlb_Product.Enabled = True
    Call LockScreen(False)
    
    Call LogMessage("tbl_product_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)

    Exit Sub
End Sub

Private Sub UpdateMainToolbar()
On Error GoTo ErrHandler
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateMainToolbar")
End Sub

Private Sub SubItem_Exit()
On Error GoTo ErrHandler
    
    ' pop last item in screen mode stack
    Call popScreenMode
    
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_Exit")
End Sub

' clear all controls values
Private Sub SubItem_Clear()
On Error GoTo ErrHandler
    mb_Initializing = True
    Call ClearForm(UserControl.Controls, fra_authLevelDetail)
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Clear")
End Sub


' initialize view mode
Private Sub SubItem_ViewInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    
    Call SubItem_Clear
    
    ' loading values
    Call SubItem_LoadValues(ao_detailData)
    
    fra_authLevelDetail.Visible = True
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_ViewInit")
End Sub

' initialize delete mode
Private Sub SubItem_DeleteInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smDeleteItem)
    Call SubItem_Clear
        
    Call SubItem_LoadValues(ao_detailData)
    
    Call UpdateUI(ArmScreenMode.smDeleteItem)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_DeleteInit")
End Sub

' initialize add mode
Private Sub SubItem_AddInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smAddItem)
    Call SubItem_Clear
    
    If ao_detailData.Exists("Z_Creation") Then
        ao_detailData("Z_Creation") = Format(Now, "DD\/MM\/YYYY")
    Else
        Call ao_detailData.Add("Z_Creation", Format(Now, "DD\/MM\/YYYY"))
    End If
    Call SubItem_LoadValues(ao_detailData)
    
    Call UpdateUI(ArmScreenMode.smAddItem)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_AddInit")
End Sub

' initialize update mode
Private Sub SubItem_UpdateInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smUpdateItem)
    Call SubItem_Clear
    
    If ao_detailData("change") <> "A" Then ao_detailData("change") = "U"
    
    Call SubItem_LoadValues(ao_detailData)
    
    Call UpdateUI(ArmScreenMode.smUpdateItem)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_UpdateInit")
End Sub

' workw with smViewItem, smUpdateItem and smDeleteItem mode
Private Sub SubItem_Restore(ByRef as_detailData As Dictionary)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(activeScreenMode)
    Call SubItem_Clear
    
    Call SubItem_LoadValues(as_detailData)
    Call UpdateUI

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_Restore")
End Sub

' adds Subitem
Private Sub SubItem_Add()
On Error GoTo ErrHandler

    ' check values and throw message if neccessary
    If Not Item_Check(moa_DetailFieldsMandatory, moa_DetailFieldsNumeric) Then
        Exit Sub
    End If
    
    ' M723
    If CDbl(txt_level.Text) < 0.01 Or CDbl(txt_level.Text) > 100 Then
        MsgBox MsgText(ErrMsg_M723, ms_Language_Code, "#M723 - Value must be between 0.01 and 100.00."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        txt_level.SetFocus
        Exit Sub
    End If

    ' M540
    If TestGridContaintRow(grd_authLevel, "SPR_Code", cbo_role.SelectedItem.Key, True) Then
        MsgBox MsgText(ErrMsg_M540, ms_Language_Code, "#The same role cannot appear twice for this Authorisation Market/Product group combination."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Sub
    End If
    
    ' M550
    If txt_priority.Text = "0" And txt_level.Text <> 100 Then
        MsgBox MsgText(ErrMsg_M550, ms_Language_Code, "#The Authorisation level must be 100 for the highest priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Sub
    End If
    
    ' M570
    If TestGridContaintRow(grd_authLevel, "DiscountPercent", txt_level.Text, True) Then
        MsgBox MsgText(ErrMsg_M570, ms_Language_Code, "#The Authorisation level you have selected aready exists for this Authorisation Market/Product group combination."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Sub
    End If

    ' M560
    Dim ll_i As Long
    For ll_i = 0 To grd_authLevel.Rows - 1
        If grd_authLevel.Data(ll_i, "Priority") > CLng(txt_priority.Text) And grd_authLevel.Data(ll_i, "DiscountPercent") >= CDbl(txt_level.Text) Then
            MsgBox MsgText(ErrMsg_M560, ms_Language_Code, "#The Authorisation level you have chosen must be higer than the lower priority role and less than the higher priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            Exit Sub
        End If
        If grd_authLevel.Data(ll_i, "Priority") < CLng(txt_priority.Text) And grd_authLevel.Data(ll_i, "DiscountPercent") <= CDbl(txt_level.Text) Then
            MsgBox MsgText(ErrMsg_M560, ms_Language_Code, "#The Authorisation level you have chosen must be higer than the lower priority role and less than the higher priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            Exit Sub
        End If
    Next
    
    
    Dim lo_detailData As Dictionary
    Set lo_detailData = New Dictionary
    lo_detailData.CompareMode = TextCompare
    
    ' do the local update of grid
    Call FillDataSrcArray(lo_detailData, Build_SrzString(UserControl.Controls, fra_authLevelDetail))
    Call lo_detailData.Add("SPGAM_Id", txt_Key.Text)
    
    Call AddLineToGrid(grd_authLevel, lo_detailData)
    
    Set lo_detailData = Nothing
    
    Call SubItem_Exit
    
    Exit Sub
ErrHandler:
    Set lo_detailData = Nothing
    Call ErrorHandler(Extender.Name & ".SubItem_Add")
End Sub

' update current edited Subitem
Private Sub SubItem_Update()
On Error GoTo ErrHandler
    If Not Item_Check(moa_DetailFieldsMandatory, moa_DetailFieldsNumeric) Then
        Exit Sub
    End If
    
    ' M723
    If CDbl(txt_level.Text) < 0.01 Or CDbl(txt_level.Text) > 100 Then
        MsgBox MsgText(ErrMsg_M723, ms_Language_Code, "#M723 - Value must be between 0.01 and 100.00."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        txt_level.SetFocus
        Exit Sub
    End If
    
    ' M540
    If TestGridContaintRow(grd_authLevel, "SPR_Code", cbo_role.SelectedItem.Key, False) Then
        MsgBox MsgText(ErrMsg_M540, ms_Language_Code, "#The same role cannot appear twice for this Authorisation Market/Product group combination."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Sub
    End If
    
    ' M550
    If txt_priority.Text = "0" And txt_level.Text <> 100 Then
        MsgBox MsgText(ErrMsg_M550, ms_Language_Code, "#The Authorisation level must be 100 for the highest priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Sub
    End If
    
    ' M570
    If TestGridContaintRow(grd_authLevel, "DiscountPercent", txt_level.Text, False) Then
        MsgBox MsgText(ErrMsg_M570, ms_Language_Code, "#The Authorisation level you have selected aready exists for this Authorisation Market/Product group combination."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Exit Sub
    End If

    ' M560
    Dim ll_i As Long
    For ll_i = 0 To grd_authLevel.Rows - 1
        If grd_authLevel.Data(ll_i, "Priority") > CLng(txt_priority.Text) And grd_authLevel.Data(ll_i, "DiscountPercent") >= CDbl(txt_level.Text) Then
            MsgBox MsgText(ErrMsg_M560, ms_Language_Code, "#The Authorisation level you have chosen must be higer than the lower priority role and less than the higher priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            Exit Sub
        End If
        If grd_authLevel.Data(ll_i, "Priority") < CLng(txt_priority.Text) And grd_authLevel.Data(ll_i, "DiscountPercent") <= CDbl(txt_level.Text) Then
            MsgBox MsgText(ErrMsg_M560, ms_Language_Code, "#The Authorisation level you have chosen must be higer than the lower priority role and less than the higher priority role."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            Exit Sub
        End If
    Next

    Dim lo_detailData As Dictionary
    Set lo_detailData = New Dictionary
    lo_detailData.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_detailData, Build_SrzString(UserControl.Controls, fra_authLevelDetail))
    
    ' do local update of the grid
    Call UpdateLineToGrid(grd_authLevel, lo_detailData, Array("SPR_Code"))
    
    Set lo_detailData = Nothing
    
    Call SubItem_Exit

    Exit Sub
ErrHandler:
    Set lo_detailData = Nothing
    Call ErrorHandler(Extender.Name & ".SubItem_Update")
End Sub

' deletes Subitem
Private Sub SubItem_Delete()
On Error GoTo ErrHandler
    
    If SendMessage(MsgText(ErrMsg_M360, ms_Language_Code, "#Do you really want to delete this record."), vbQuestion + vbYesNo) = vbYes Then
    
        ' do local update of the grid
        Call DeleteLineToGrid(grd_authLevel, Array("SPR_Code"), grd_authLevel.SelectedKey(0))

        Call SubItem_Exit
        
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_Delete")
End Sub

Private Sub SubItem_LoadValues(ByRef as_detailData As Dictionary)
On Error GoTo ErrHandler
    Dim ls_req As String
    mb_Initializing = True
    
    ' load main record
    Call LoadDataToSubForm(as_detailData, UserControl.Controls, fra_authLevelDetail)
    
    mb_Initializing = False

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_LoadValues")
End Sub

Private Function IsTelNum(ByVal as_telNum As String) As Boolean
On Error GoTo ErrorMessage
    Dim ll_i  As Long
    IsTelNum = False
    ' must start with 00XXY
    If Len(as_telNum) < 5 Then Exit Function
'    If Left(as_telNum, 2) <> "00" Then Exit Function
    
    ' tel number must containt only digits 0..9
    For ll_i = 1 To Len(as_telNum)
        Select Case Mid(as_telNum, ll_i, 1)
            Case "+", "-", " ", "0" To "9"
            Case Else
                Exit Function
        End Select
    Next
    IsTelNum = True
    Exit Function
ErrorMessage:
    Call ErrorHandler(Extender.Name & ".IsTelNum()")
End Function


Private Function IsEMail(AString As String) As Boolean
On Error GoTo ErrorMessage
Dim Pos1 As Integer
Dim Pos2 As Integer

    Pos1 = InStr(1, AString, "@")
    If Not Pos1 > 1 Then
        IsEMail = False
    Else
        Pos2 = InStr(Pos1, AString, ".")
        If Not Pos2 > 1 Then
            IsEMail = False
        ElseIf Pos2 = Pos1 + 1 Then
            IsEMail = False
        ElseIf Pos2 = Len(AString) Then
            IsEMail = False
        Else
            IsEMail = True
        End If
    End If

    Exit Function
ErrorMessage:
    Call ErrorHandler(Extender.Name & ".IsEMail()")
End Function

' 0 meas everything ok
Private Function SubItem_CanUpdate() As Long
On Error GoTo ErrHandler
    SubItem_CanUpdate = 0
    
    If grd_authLevel.SelectedCount = 0 Then
        SubItem_CanUpdate = WarMsgSelectRow
        Exit Function
    End If
    If grd_authLevel.CurrentLine("change") = "D" Then
        SubItem_CanUpdate = ErrMsgItemIsDeleted
        Exit Function
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_CanUpdate")
End Function

' 0 meas everything ok
Private Function SubItem_CanDelete() As Long
On Error GoTo ErrHandler
    SubItem_CanDelete = 0
    
    If grd_authLevel.SelectedCount = 0 Then
        SubItem_CanDelete = WarMsgSelectRow
        Exit Function
    End If
    
    If grd_authLevel.CurrentLine("change") = "D" Then
        SubItem_CanDelete = ErrMsgItemIsDeleted
        Exit Function
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SubItem_CanDelete")
End Function

Private Function Item_CheckPG_MKT() As ErrMsg
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC SPA_ProdGroupAuthMarket_Link_chk $SPG_Code$, $SPM_Code$"
    Item_CheckPG_MKT = ErrMsgNone
    
    Dim ll_SPGAM_ID As Long
    Dim ll_cursor As Long
    Dim ls_req As String
    
    ls_req = ReplaceRequestByFrameData(C_REQ, fra_detail)
    ll_cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        Item_CheckPG_MKT = ErrMsg_M600
    End If
    
    Call mo_Db.Close(ll_cursor)
    
    Exit Function
ErrHandler:
    If ll_cursor > 0 Then
        Call mo_Db.Close(ll_cursor)
    End If
    Call ErrorHandler(Extender.Name & ".Item_CheckPG_MKT")
End Function

Private Function Item_CheckDefaultPG_MKT() As ErrMsg
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC SPA_ProdGroupAuthMarket_Link_chk2 $SPG_Code$, $SPM_Code$"
    Item_CheckDefaultPG_MKT = ErrMsgNone
    
    Dim ll_SPGAM_ID As Long
    Dim ll_cursor As Long
    Dim ls_req As String
    
    ls_req = ReplaceRequestByFrameData(C_REQ, fra_detail)
    ll_cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        Item_CheckDefaultPG_MKT = ErrMsg_M601
    End If
    
    Call mo_Db.Close(ll_cursor)
    
    Exit Function
ErrHandler:
    If ll_cursor > 0 Then
        Call mo_Db.Close(ll_cursor)
    End If
    Call ErrorHandler(Extender.Name & ".Item_CheckDefaultPG_MKT")
End Function

Public Function GetServerDate() As Date
Const REQ_GET_SERVER_DATE As String = "SELECT GetDate() as ServerDate"
On Error GoTo ErrHandler
Dim ls_req As String
Dim ll_cursor As Long
    
    GetServerDate = 0
    
    ll_cursor = OpenSQLSafe(mo_Db, REQ_GET_SERVER_DATE)
    
    Debug.Assert (ll_cursor <> 0)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        GetServerDate = mo_Db.GetFields(ll_cursor, "ServerDate")
    End If
    
    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
    
    Exit Function
ErrHandler:
    GetServerDate = 0
    Call ErrorHandler(Extender.Name & ".EntryIsUsed")
End Function

Private Function EntryIsUsed(ByVal al_SPGAM_Id As Long, ByVal as_atDate As Date) As Boolean
On Error GoTo ErrHandler
    
Dim ls_req As String
Dim ll_cursor As Long
    
    EntryIsUsed = False
    
    ls_req = ReplacePlaceHolder(REQ_SPA_PG_MKT_IS_USED, "$SPGAM_Id$", al_SPGAM_Id)
    ls_req = ReplacePlaceHolder(ls_req, "$TESTDATE$", SqlDate(as_atDate))
    ll_cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        EntryIsUsed = True
    End If
    
    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
    
    Exit Function
ErrHandler:
    If ll_cursor > 0 Then
        Call mo_Db.Close(ll_cursor)
    End If
    Call ErrorHandler(Extender.Name & ".EntryIsUsed")
End Function

Private Function GetToken() As Boolean
On Error GoTo ErrHandler
    GetToken = mo_tokenManager.GetToken(C_ABPE_SPA_TOKEN, SPA_Admin_ScreenValidate)
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetToken")
End Function

Private Sub ReleaseToken()
On Error GoTo ErrHandler
    Call mo_tokenManager.ReleaseToken
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReleaseToken")
End Sub



' 0 meas everything ok
Private Function Item_CanUpdate() As ErrMsg
On Error GoTo ErrHandler
    Item_CanUpdate = ErrMsgNone
    
'    If txt_VDate_End.Text <> "" And txt_VDate_End.Text < SqlDate(cal_changeRequested.date_dt()) Then
    If txt_VDate_End.Text <> "" Then
        Item_CanUpdate = ErrMsg_M610                          ' item cannot be updated because it is closed
        Exit Function
    End If
    
'    If txt_isActive.Text <> "X" Then
'        Item_CanUpdate = ErrMsg_M610                          ' item cannot be updated because it is not active
'    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_CanUpdate")
End Function

' 0 meas everything ok
Private Function Item_CanDelete() As ErrMsg
On Error GoTo ErrHandler
    Item_CanDelete = ErrMsgNone
    
    If txt_VDate_End.Text <> "" And txt_VDate_End.Text < SqlDate(cal_changeRequested.date_dt()) Then
        Item_CanDelete = ErrMsg_M610                          ' item cannot be deleted because it is closed
        Exit Function
    End If
    
'    If txt_isActive.Text <> "X" Then
'        Item_CanDelete = ErrMsg_M610                          ' item cannot be deleted because it is not active
'    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_CanDelete")
End Function



